package com.ejie.ab04b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.model.VfichaApertura;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * VfichaAperturaDaoImpl generated by UDA, 16-jun-2017 10:17:16.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class VfichaAperturaDaoImpl implements VfichaAperturaDao {
	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<VfichaApertura> rwMap = new RowMapper<VfichaApertura>() {
		public VfichaApertura mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new VfichaApertura(resultSet.getString("NUMEXP"),
					resultSet.getString("PROVINCIACAST"),
					resultSet.getString("PROVINCIAEUSK"),
					resultSet.getString("ANIO"), resultSet.getString("DIA"),
					resultSet.getString("MES"), resultSet.getString("MESEUS"),
					resultSet.getString("EMPRESAEXISTENTE"),
					resultSet.getString("EMPRESANOEXISTENTE"),
					resultSet.getString("NUMERODOCUMENTO"),
					resultSet.getString("RAZONSOCIAL"),
					resultSet.getString("DIRECCION"),
					resultSet.getString("MUNICIPIOEMPRESA"),
					resultSet.getString("TERRITORIOEMPRESA"),
					resultSet.getString("CP"),
					resultSet.getString("TELEFONOEMPRESA"),
					resultSet.getString("ACTIVIDADECONOMICA"),
					resultSet.getString("ENTIDADGESTORACOLABORADORA"),
					resultSet.getString("NUEVOCENTRO"),
					resultSet.getString("REANUDACIONACTIVIDAD"),
					resultSet.getString("CAMBIOACTIVIDAD"),
					resultSet.getString("TRASLADO"),
					resultSet.getString("CAMBIORAZONSOCIAL"),
					resultSet.getString("NOMBRECENTRO"),
					resultSet.getString("MUNICIPIOCENTRO"),
					resultSet.getString("PROVINCIACENTRO"),
					resultSet.getString("DIRECCIONCENTRO"),
					resultSet.getString("ACTIVIDADECONOMICACENTRO"),
					resultSet.getString("FAXCENTRO"),
					resultSet.getString("EMAILCENTRO"),
					resultSet.getString("TELEFONOCENTRO"),
					resultSet.getString("CPCENTRO"),
					resultSet.getString("DIAINICIOACTIVIDAD"),
					resultSet.getString("MESINICIOACTIVIDAD"),
					resultSet.getString("ANIOINICIOACTIVIDAD"),
					resultSet.getString("NSSPROVCENTRO"),
					resultSet.getString("NSSNUMCENTRO"),
					resultSet.getString("NSSDIGCENTRO"),
					resultSet.getLong("TRABAJADORESHOMBRE"),
					resultSet.getLong("TRABAJADORESMUJER"),
					resultSet.getLong("TOTALTRABAJADORES"),
					resultSet.getString("NUMREGEMP"),
					resultSet.getString("CLASECENTRO"),
					resultSet.getString("CLASECENTROEUS"),
					resultSet.getString("DESCRIPCIONOBRACENTRO"),
					resultSet.getString("ACOMPANAPLANSEGURIDAD"),
					resultSet.getString("NOACOMPANAPLANSEGURIDAD"),
					resultSet.getString("ADJUNTAPROYECTOTECNICO"),
					resultSet.getString("NOADJUNTAPROYECTOTECNICO"),
					resultSet.getInt("MODALIDADORGANIZATIVA"),
					resultSet.getString("MODALIDADORGANIZATIVADESC"),
					resultSet.getString("MAQUINARIAHERRAMIENTAS"),
					resultSet.getInt("SUPERFICIECONSTRUIDA"),
					resultSet.getBigDecimal("POTENCIAINSTALADA"),
					resultSet.getString("TRABAJOANEXOI"),
					resultSet.getString("NOTRABAJOANEXOI"),
					resultSet.getString("APARTADOANEXOI"),
					resultSet.getString("APARTADOANEXOIEUS"),
					resultSet.getString("FIRMA"), resultSet.getLong("CODOBRA"),
					resultSet.getString("TIPOOBRA"),
					resultSet.getString("TIPOOBRAEUS"),
					resultSet.getString("DIREXACTAOBRA"),
					resultSet.getDate("FECHACOMIENZOOBRA"),
					resultSet.getInt("NUMMAXTRABOBRA"),
					resultSet.getString("DURACIONPREVISTA"),
					resultSet.getString("DURACIONPREVISTACONTRATISTA"),
					resultSet.getLong("NUMEROCONTRATISTA"),
					resultSet.getString("REALIZATRABAJOS"),
					resultSet.getString("NOREALIZATRABAJOS"),
					resultSet.getString("TIPOANEXO2"),
					resultSet.getString("DESCRIPCIONANEXO2"));
		}
	};

	private RowMapper<VfichaApertura> rwMapPK = new RowMapper<VfichaApertura>() {
		public VfichaApertura mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new VfichaApertura(resultSet.getString("NUMEXP"),
					resultSet.getString("PROVINCIACAST"),
					resultSet.getString("PROVINCIAEUSK"),
					resultSet.getString("ANIO"), resultSet.getString("DIA"),
					resultSet.getString("MES"), resultSet.getString("MESEUS"),
					resultSet.getString("EMPRESAEXISTENTE"),
					resultSet.getString("EMPRESANOEXISTENTE"),
					resultSet.getString("NUMERODOCUMENTO"),
					resultSet.getString("RAZONSOCIAL"),
					resultSet.getString("DIRECCION"),
					resultSet.getString("MUNICIPIOEMPRESA"),
					resultSet.getString("TERRITORIOEMPRESA"),
					resultSet.getString("CP"),
					resultSet.getString("TELEFONOEMPRESA"),
					resultSet.getString("ACTIVIDADECONOMICA"),
					resultSet.getString("ENTIDADGESTORACOLABORADORA"),
					resultSet.getString("NUEVOCENTRO"),
					resultSet.getString("REANUDACIONACTIVIDAD"),
					resultSet.getString("CAMBIOACTIVIDAD"),
					resultSet.getString("TRASLADO"),
					resultSet.getString("CAMBIORAZONSOCIAL"),
					resultSet.getString("NOMBRECENTRO"),
					resultSet.getString("MUNICIPIOCENTRO"),
					resultSet.getString("PROVINCIACENTRO"),
					resultSet.getString("DIRECCIONCENTRO"),
					resultSet.getString("ACTIVIDADECONOMICACENTRO"),
					resultSet.getString("FAXCENTRO"),
					resultSet.getString("EMAILCENTRO"),
					resultSet.getString("TELEFONOCENTRO"),
					resultSet.getString("CPCENTRO"),
					resultSet.getString("DIAINICIOACTIVIDAD"),
					resultSet.getString("MESINICIOACTIVIDAD"),
					resultSet.getString("ANIOINICIOACTIVIDAD"),
					resultSet.getString("NSSPROVCENTRO"),
					resultSet.getString("NSSNUMCENTRO"),
					resultSet.getString("NSSDIGCENTRO"),
					resultSet.getLong("TRABAJADORESHOMBRE"),
					resultSet.getLong("TRABAJADORESMUJER"),
					resultSet.getLong("TOTALTRABAJADORES"),
					resultSet.getString("NUMREGEMP"),
					resultSet.getString("CLASECENTRO"),
					resultSet.getString("CLASECENTROEUS"),
					resultSet.getString("DESCRIPCIONOBRACENTRO"),
					resultSet.getString("ACOMPANAPLANSEGURIDAD"),
					resultSet.getString("NOACOMPANAPLANSEGURIDAD"),
					resultSet.getString("ADJUNTAPROYECTOTECNICO"),
					resultSet.getString("NOADJUNTAPROYECTOTECNICO"),
					resultSet.getInt("MODALIDADORGANIZATIVA"),
					resultSet.getString("MODALIDADORGANIZATIVADESC"),
					resultSet.getString("MAQUINARIAHERRAMIENTAS"),
					resultSet.getInt("SUPERFICIECONSTRUIDA"),
					resultSet.getBigDecimal("POTENCIAINSTALADA"),
					resultSet.getString("TRABAJOANEXOI"),
					resultSet.getString("NOTRABAJOANEXOI"),
					resultSet.getString("APARTADOANEXOI"),
					resultSet.getString("APARTADOANEXOIEUS"),
					resultSet.getString("FIRMA"), resultSet.getLong("CODOBRA"),
					resultSet.getString("TIPOOBRA"),
					resultSet.getString("TIPOOBRAEUS"),
					resultSet.getString("DIREXACTAOBRA"),
					resultSet.getDate("FECHACOMIENZOOBRA"),
					resultSet.getInt("NUMMAXTRABOBRA"),
					resultSet.getString("DURACIONPREVISTA"),
					resultSet.getString("DURACIONPREVISTACONTRATISTA"),
					resultSet.getLong("NUMEROCONTRATISTA"),
					resultSet.getString("REALIZATRABAJOS"),
					resultSet.getString("NOREALIZATRABAJOS"),
					resultSet.getString("TIPOANEXO2"),
					resultSet.getString("DESCRIPCIONANEXO2"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * dataSource DataSource
	 * 
	 * @param dataSource
	 *            the new data source
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the VfichaApertura table.
	 * 
	 * vfichaapertura VfichaApertura VfichaApertura
	 * 
	 * @param vfichaapertura
	 *            the vfichaapertura
	 * @return the vficha apertura
	 */
	public VfichaApertura add(VfichaApertura vfichaapertura) {
		String query = "INSERT INTO VFICHA_APERTURA (NUMEXP, PROVINCIACAST, PROVINCIAEUSK, ANIO, DIA, MES, MESEUS, EMPRESAEXISTENTE, EMPRESANOEXISTENTE, NUMERODOCUMENTO, RAZONSOCIAL, DIRECCION, MUNICIPIOEMPRESA, TERRITORIOEMPRESA, CP, TELEFONOEMPRESA, ACTIVIDADECONOMICA, ENTIDADGESTORACOLABORADORA, NUEVOCENTRO, REANUDACIONACTIVIDAD, CAMBIOACTIVIDAD, TRASLADO, NOMBRECENTRO, MUNICIPIOCENTRO, PROVINCIACENTRO, DIRECCIONCENTRO, ACTIVIDADECONOMICACENTRO, FAXCENTRO, TELEFONOCENTRO, CPCENTRO, DIAINICIOACTIVIDAD, MESINICIOACTIVIDAD, ANIOINICIOACTIVIDAD, NSSPROVCENTRO, NSSNUMCENTRO, NSSDIGCENTRO, TRABAJADORESHOMBRE, TRABAJADORESMUJER, TOTALTRABAJADORES, CLASECENTRO, CLASECENTROEUS, DESCRIPCIONOBRACENTRO, ACOMPANAPLANSEGURIDAD, NOACOMPANAPLANSEGURIDAD, ADJUNTAPROYECTOTECNICO, NOADJUNTAPROYECTOTECNICO, MAQUINARIAHERRAMIENTAS, SUPERFICIECONSTRUIDA, POTENCIAINSTALADA, TRABAJOANEXOI, NOTRABAJOANEXOI, APARTADOANEXOI, APARTADOANEXOIEUS, FIRMA, CODOBRA, TIPOOBRA, TIPOOBRAEUS, DIREXACTAOBRA, FECHACOMIENZOOBRA, DURACIONPREVISTA, DURACIONPREVISTACONTRATISTA, NUMEROCONTRATISTA, REALIZATRABAJOS, NOREALIZATRABAJOS, TIPOANEXO2, DESCRIPCIONANEXO2) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, vfichaapertura.getNumexp(),
				vfichaapertura.getProvinciacast(),
				vfichaapertura.getProvinciaeusk(), vfichaapertura.getAnio(),
				vfichaapertura.getDia(), vfichaapertura.getMes(),
				vfichaapertura.getMeseus(),
				vfichaapertura.getEmpresaexistente(),
				vfichaapertura.getEmpresanoexistente(),
				vfichaapertura.getNumerodocumento(),
				vfichaapertura.getRazonsocial(), vfichaapertura.getDireccion(),
				vfichaapertura.getMunicipioempresa(),
				vfichaapertura.getTerritorioempresa(), vfichaapertura.getCp(),
				vfichaapertura.getTelefonoempresa(),
				vfichaapertura.getActividadeconomica(),
				vfichaapertura.getEntidadgestoracolaboradora(),
				vfichaapertura.getNuevocentro(),
				vfichaapertura.getReanudacionactividad(),
				vfichaapertura.getCambioactividad(),
				vfichaapertura.getTraslado(), vfichaapertura.getNombrecentro(),
				vfichaapertura.getMunicipiocentro(),
				vfichaapertura.getProvinciacentro(),
				vfichaapertura.getDireccioncentro(),
				vfichaapertura.getActividadeconomicacentro(),
				vfichaapertura.getFaxcentro(),
				vfichaapertura.getTelefonocentro(),
				vfichaapertura.getCpcentro(),
				vfichaapertura.getDiainicioactividad(),
				vfichaapertura.getMesinicioactividad(),
				vfichaapertura.getAnioinicioactividad(),
				vfichaapertura.getNssprovcentro(),
				vfichaapertura.getNssnumcentro(),
				vfichaapertura.getNssdigcentro(),
				vfichaapertura.getTrabajadoreshombre(),
				vfichaapertura.getTrabajadoresmujer(),
				vfichaapertura.getTotaltrabajadores(),
				vfichaapertura.getClasecentro(),
				vfichaapertura.getClasecentroeus(),
				vfichaapertura.getDescripcionobracentro(),
				vfichaapertura.getAcompanaplanseguridad(),
				vfichaapertura.getNoacompanaplanseguridad(),
				vfichaapertura.getAdjuntaproyectotecnico(),
				vfichaapertura.getNoadjuntaproyectotecnico(),
				vfichaapertura.getMaquinariaherramientas(),
				vfichaapertura.getSuperficieconstruida(),
				vfichaapertura.getPotenciainstalada(),
				vfichaapertura.getTrabajoanexoi(),
				vfichaapertura.getNotrabajoanexoi(),
				vfichaapertura.getApartadoanexoi(),
				vfichaapertura.getApartadoanexoieus(),
				vfichaapertura.getFirma(), vfichaapertura.getCodobra(),
				vfichaapertura.getTipoobra(), vfichaapertura.getTipoobraeus(),
				vfichaapertura.getDirexactaobra(),
				vfichaapertura.getFechacomienzoobra(),
				vfichaapertura.getDuracionprevista(),
				vfichaapertura.getDuracionprevistacontratista(),
				vfichaapertura.getNumerocontratista(),
				vfichaapertura.getRealizatrabajos(),
				vfichaapertura.getNorealizatrabajos(),
				vfichaapertura.getTipoanexo2(),
				vfichaapertura.getDescripcionanexo2());
		return vfichaapertura;
	}

	/**
	 * Updates a single row in the VfichaApertura table.
	 * 
	 * vfichaapertura VfichaApertura VfichaApertura
	 * 
	 * @param vfichaapertura
	 *            the vfichaapertura
	 * @return the vficha apertura
	 */
	public VfichaApertura update(VfichaApertura vfichaapertura) {
		String query = "UPDATE VFICHA_APERTURA SET  WHERE NUMEXP=? AND PROVINCIACAST=? AND PROVINCIAEUSK=? AND ANIO=? AND DIA=? AND MES=? AND MESEUS=? AND EMPRESAEXISTENTE=? AND EMPRESANOEXISTENTE=? AND NUMERODOCUMENTO=? AND RAZONSOCIAL=? AND DIRECCION=? AND MUNICIPIOEMPRESA=? AND TERRITORIOEMPRESA=? AND CP=? AND TELEFONOEMPRESA=? AND ACTIVIDADECONOMICA=? AND ENTIDADGESTORACOLABORADORA=? AND NUEVOCENTRO=? AND REANUDACIONACTIVIDAD=? AND CAMBIOACTIVIDAD=? AND TRASLADO=? AND NOMBRECENTRO=? AND MUNICIPIOCENTRO=? AND PROVINCIACENTRO=? AND DIRECCIONCENTRO=? AND ACTIVIDADECONOMICACENTRO=? AND FAXCENTRO=? AND TELEFONOCENTRO=? AND CPCENTRO=? AND DIAINICIOACTIVIDAD=? AND MESINICIOACTIVIDAD=? AND ANIOINICIOACTIVIDAD=? AND NSSPROVCENTRO=? AND NSSNUMCENTRO=? AND NSSDIGCENTRO=? AND TRABAJADORESHOMBRE=? AND TRABAJADORESMUJER=? AND TOTALTRABAJADORES=? AND CLASECENTRO=? AND CLASECENTROEUS=? AND DESCRIPCIONOBRACENTRO=? AND ACOMPANAPLANSEGURIDAD=? AND NOACOMPANAPLANSEGURIDAD=? AND ADJUNTAPROYECTOTECNICO=? AND NOADJUNTAPROYECTOTECNICO=? AND MAQUINARIAHERRAMIENTAS=? AND SUPERFICIECONSTRUIDA=? AND POTENCIAINSTALADA=? AND TRABAJOANEXOI=? AND NOTRABAJOANEXOI=? AND APARTADOANEXOI=? AND APARTADOANEXOIEUS=? AND FIRMA=? AND CODOBRA=? AND TIPOOBRA=? AND TIPOOBRAEUS=? AND DIREXACTAOBRA=? AND FECHACOMIENZOOBRA=? AND DURACIONPREVISTA=? AND DURACIONPREVISTACONTRATISTA=? AND NUMEROCONTRATISTA=? AND REALIZATRABAJOS=? AND NOREALIZATRABAJOS=? AND TIPOANEXO2=? AND DESCRIPCIONANEXO2=?";
		this.jdbcTemplate.update(query, vfichaapertura.getNumexp(),
				vfichaapertura.getProvinciacast(),
				vfichaapertura.getProvinciaeusk(), vfichaapertura.getAnio(),
				vfichaapertura.getDia(), vfichaapertura.getMes(),
				vfichaapertura.getMeseus(),
				vfichaapertura.getEmpresaexistente(),
				vfichaapertura.getEmpresanoexistente(),
				vfichaapertura.getNumerodocumento(),
				vfichaapertura.getRazonsocial(), vfichaapertura.getDireccion(),
				vfichaapertura.getMunicipioempresa(),
				vfichaapertura.getTerritorioempresa(), vfichaapertura.getCp(),
				vfichaapertura.getTelefonoempresa(),
				vfichaapertura.getActividadeconomica(),
				vfichaapertura.getEntidadgestoracolaboradora(),
				vfichaapertura.getNuevocentro(),
				vfichaapertura.getReanudacionactividad(),
				vfichaapertura.getCambioactividad(),
				vfichaapertura.getTraslado(), vfichaapertura.getNombrecentro(),
				vfichaapertura.getMunicipiocentro(),
				vfichaapertura.getProvinciacentro(),
				vfichaapertura.getDireccioncentro(),
				vfichaapertura.getActividadeconomicacentro(),
				vfichaapertura.getFaxcentro(),
				vfichaapertura.getTelefonocentro(),
				vfichaapertura.getCpcentro(),
				vfichaapertura.getDiainicioactividad(),
				vfichaapertura.getMesinicioactividad(),
				vfichaapertura.getAnioinicioactividad(),
				vfichaapertura.getNssprovcentro(),
				vfichaapertura.getNssnumcentro(),
				vfichaapertura.getNssdigcentro(),
				vfichaapertura.getTrabajadoreshombre(),
				vfichaapertura.getTrabajadoresmujer(),
				vfichaapertura.getTotaltrabajadores(),
				vfichaapertura.getClasecentro(),
				vfichaapertura.getClasecentroeus(),
				vfichaapertura.getDescripcionobracentro(),
				vfichaapertura.getAcompanaplanseguridad(),
				vfichaapertura.getNoacompanaplanseguridad(),
				vfichaapertura.getAdjuntaproyectotecnico(),
				vfichaapertura.getNoadjuntaproyectotecnico(),
				vfichaapertura.getMaquinariaherramientas(),
				vfichaapertura.getSuperficieconstruida(),
				vfichaapertura.getPotenciainstalada(),
				vfichaapertura.getTrabajoanexoi(),
				vfichaapertura.getNotrabajoanexoi(),
				vfichaapertura.getApartadoanexoi(),
				vfichaapertura.getApartadoanexoieus(),
				vfichaapertura.getFirma(), vfichaapertura.getCodobra(),
				vfichaapertura.getTipoobra(), vfichaapertura.getTipoobraeus(),
				vfichaapertura.getDirexactaobra(),
				vfichaapertura.getFechacomienzoobra(),
				vfichaapertura.getDuracionprevista(),
				vfichaapertura.getDuracionprevistacontratista(),
				vfichaapertura.getNumerocontratista(),
				vfichaapertura.getRealizatrabajos(),
				vfichaapertura.getNorealizatrabajos(),
				vfichaapertura.getTipoanexo2(),
				vfichaapertura.getDescripcionanexo2());
		return vfichaapertura;
	}

	/**
	 * Finds a single row in the VfichaApertura table.
	 * 
	 * vfichaapertura VfichaApertura VfichaApertura
	 * 
	 * @param vfichaapertura
	 *            the vfichaapertura
	 * @return the vficha apertura
	 */
	@Transactional(readOnly = true)
	public VfichaApertura find(VfichaApertura vfichaapertura) {
		String query = "SELECT t1.NUMEXP NUMEXP, t1.PROVINCIACAST PROVINCIACAST, t1.PROVINCIAEUSK PROVINCIAEUSK, t1.ANIO ANIO, t1.DIA DIA, t1.MES MES, t1.MESEUS MESEUS, t1.EMPRESAEXISTENTE EMPRESAEXISTENTE, t1.EMPRESANOEXISTENTE EMPRESANOEXISTENTE, t1.NUMERODOCUMENTO NUMERODOCUMENTO, t1.RAZONSOCIAL RAZONSOCIAL, t1.DIRECCION DIRECCION, t1.MUNICIPIOEMPRESA MUNICIPIOEMPRESA, t1.TERRITORIOEMPRESA TERRITORIOEMPRESA, t1.CP CP, t1.TELEFONOEMPRESA TELEFONOEMPRESA, t1.ACTIVIDADECONOMICA ACTIVIDADECONOMICA, t1.ENTIDADGESTORACOLABORADORA ENTIDADGESTORACOLABORADORA, t1.NUEVOCENTRO NUEVOCENTRO, t1.REANUDACIONACTIVIDAD REANUDACIONACTIVIDAD, t1.CAMBIOACTIVIDAD CAMBIOACTIVIDAD, t1.TRASLADO TRASLADO,t1.CAMBIORAZONSOCIAL CAMBIORAZONSOCIAL, t1.NOMBRECENTRO NOMBRECENTRO, t1.MUNICIPIOCENTRO MUNICIPIOCENTRO, t1.PROVINCIACENTRO PROVINCIACENTRO, t1.DIRECCIONCENTRO DIRECCIONCENTRO, t1.ACTIVIDADECONOMICACENTRO ACTIVIDADECONOMICACENTRO, t1.FAXCENTRO FAXCENTRO,t1.EMAILCENTRO EMAILCENTRO, t1.TELEFONOCENTRO TELEFONOCENTRO, t1.CPCENTRO CPCENTRO, t1.DIAINICIOACTIVIDAD DIAINICIOACTIVIDAD, t1.MESINICIOACTIVIDAD MESINICIOACTIVIDAD, t1.ANIOINICIOACTIVIDAD ANIOINICIOACTIVIDAD, t1.NSSPROVCENTRO NSSPROVCENTRO, t1.NSSNUMCENTRO NSSNUMCENTRO, t1.NSSDIGCENTRO NSSDIGCENTRO, t1.TRABAJADORESHOMBRE TRABAJADORESHOMBRE, t1.TRABAJADORESMUJER TRABAJADORESMUJER, t1.TOTALTRABAJADORES TOTALTRABAJADORES, t1.NUMREGEMP NUMREGEMP, t1.CLASECENTRO CLASECENTRO, t1.CLASECENTROEUS CLASECENTROEUS, t1.DESCRIPCIONOBRACENTRO DESCRIPCIONOBRACENTRO, t1.ACOMPANAPLANSEGURIDAD ACOMPANAPLANSEGURIDAD, t1.NOACOMPANAPLANSEGURIDAD NOACOMPANAPLANSEGURIDAD, t1.ADJUNTAPROYECTOTECNICO ADJUNTAPROYECTOTECNICO, t1.NOADJUNTAPROYECTOTECNICO NOADJUNTAPROYECTOTECNICO, t1.MODALIDADORGANIZATIVA MODALIDADORGANIZATIVA, t1.MODALIDADORGANIZATIVADESC MODALIDADORGANIZATIVADESC, t1.MAQUINARIAHERRAMIENTAS MAQUINARIAHERRAMIENTAS, t1.SUPERFICIECONSTRUIDA SUPERFICIECONSTRUIDA, t1.POTENCIAINSTALADA POTENCIAINSTALADA, t1.TRABAJOANEXOI TRABAJOANEXOI, t1.NOTRABAJOANEXOI NOTRABAJOANEXOI, t1.APARTADOANEXOI APARTADOANEXOI, t1.APARTADOANEXOIEUS APARTADOANEXOIEUS, t1.FIRMA FIRMA, t1.CODOBRA CODOBRA, t1.TIPOOBRA TIPOOBRA, t1.TIPOOBRAEUS TIPOOBRAEUS, t1.DIREXACTAOBRA DIREXACTAOBRA, t1.FECHACOMIENZOOBRA FECHACOMIENZOOBRA, t1.NUMMAXTRABOBRA NUMMAXTRABOBRA, t1.DURACIONPREVISTA DURACIONPREVISTA, t1.DURACIONPREVISTACONTRATISTA DURACIONPREVISTACONTRATISTA, t1.NUMEROCONTRATISTA NUMEROCONTRATISTA, t1.REALIZATRABAJOS REALIZATRABAJOS, t1.NOREALIZATRABAJOS NOREALIZATRABAJOS, t1.TIPOANEXO2 TIPOANEXO2, t1.DESCRIPCIONANEXO2 DESCRIPCIONANEXO2 FROM VFICHA_APERTURA t1  WHERE t1.NUMEXP = ? ";

		List<VfichaApertura> vfichaaperturaList = this.jdbcTemplate.query(query,
				this.rwMap, vfichaapertura.getNumexp());
		return (VfichaApertura) DataAccessUtils
				.uniqueResult(vfichaaperturaList);
	}

	/**
	 * Removes a single row in the VfichaApertura table.
	 * 
	 * vfichaapertura VfichaApertura
	 * 
	 * @param vfichaapertura
	 *            the vfichaapertura
	 */
	public void remove(VfichaApertura vfichaapertura) {
		String query = "DELETE FROM VFICHA_APERTURA WHERE NUMEXP=? AND PROVINCIACAST=? AND PROVINCIAEUSK=? AND ANIO=? AND DIA=? AND MES=? AND MESEUS=? AND EMPRESAEXISTENTE=? AND EMPRESANOEXISTENTE=? AND NUMERODOCUMENTO=? AND RAZONSOCIAL=? AND DIRECCION=? AND MUNICIPIOEMPRESA=? AND TERRITORIOEMPRESA=? AND CP=? AND TELEFONOEMPRESA=? AND ACTIVIDADECONOMICA=? AND ENTIDADGESTORACOLABORADORA=? AND NUEVOCENTRO=? AND REANUDACIONACTIVIDAD=? AND CAMBIOACTIVIDAD=? AND TRASLADO=? AND NOMBRECENTRO=? AND MUNICIPIOCENTRO=? AND PROVINCIACENTRO=? AND DIRECCIONCENTRO=? AND ACTIVIDADECONOMICACENTRO=? AND FAXCENTRO=? AND TELEFONOCENTRO=? AND CPCENTRO=? AND DIAINICIOACTIVIDAD=? AND MESINICIOACTIVIDAD=? AND ANIOINICIOACTIVIDAD=? AND NSSPROVCENTRO=? AND NSSNUMCENTRO=? AND NSSDIGCENTRO=? AND TRABAJADORESHOMBRE=? AND TRABAJADORESMUJER=? AND TOTALTRABAJADORES=? AND CLASECENTRO=? AND CLASECENTROEUS=? AND DESCRIPCIONOBRACENTRO=? AND ACOMPANAPLANSEGURIDAD=? AND NOACOMPANAPLANSEGURIDAD=? AND ADJUNTAPROYECTOTECNICO=? AND NOADJUNTAPROYECTOTECNICO=? AND MAQUINARIAHERRAMIENTAS=? AND SUPERFICIECONSTRUIDA=? AND POTENCIAINSTALADA=? AND TRABAJOANEXOI=? AND NOTRABAJOANEXOI=? AND APARTADOANEXOI=? AND APARTADOANEXOIEUS=? AND FIRMA=? AND CODOBRA=? AND TIPOOBRA=? AND TIPOOBRAEUS=? AND DIREXACTAOBRA=? AND FECHACOMIENZOOBRA=? AND DURACIONPREVISTA=? AND DURACIONPREVISTACONTRATISTA=? AND NUMEROCONTRATISTA=? AND REALIZATRABAJOS=? AND NOREALIZATRABAJOS=? AND TIPOANEXO2=? AND DESCRIPCIONANEXO2=?";
		this.jdbcTemplate.update(query, vfichaapertura.getNumexp(),
				vfichaapertura.getProvinciacast(),
				vfichaapertura.getProvinciaeusk(), vfichaapertura.getAnio(),
				vfichaapertura.getDia(), vfichaapertura.getMes(),
				vfichaapertura.getMeseus(),
				vfichaapertura.getEmpresaexistente(),
				vfichaapertura.getEmpresanoexistente(),
				vfichaapertura.getNumerodocumento(),
				vfichaapertura.getRazonsocial(), vfichaapertura.getDireccion(),
				vfichaapertura.getMunicipioempresa(),
				vfichaapertura.getTerritorioempresa(), vfichaapertura.getCp(),
				vfichaapertura.getTelefonoempresa(),
				vfichaapertura.getActividadeconomica(),
				vfichaapertura.getEntidadgestoracolaboradora(),
				vfichaapertura.getNuevocentro(),
				vfichaapertura.getReanudacionactividad(),
				vfichaapertura.getCambioactividad(),
				vfichaapertura.getTraslado(), vfichaapertura.getNombrecentro(),
				vfichaapertura.getMunicipiocentro(),
				vfichaapertura.getProvinciacentro(),
				vfichaapertura.getDireccioncentro(),
				vfichaapertura.getActividadeconomicacentro(),
				vfichaapertura.getFaxcentro(),
				vfichaapertura.getTelefonocentro(),
				vfichaapertura.getCpcentro(),
				vfichaapertura.getDiainicioactividad(),
				vfichaapertura.getMesinicioactividad(),
				vfichaapertura.getAnioinicioactividad(),
				vfichaapertura.getNssprovcentro(),
				vfichaapertura.getNssnumcentro(),
				vfichaapertura.getNssdigcentro(),
				vfichaapertura.getTrabajadoreshombre(),
				vfichaapertura.getTrabajadoresmujer(),
				vfichaapertura.getTotaltrabajadores(),
				vfichaapertura.getClasecentro(),
				vfichaapertura.getClasecentroeus(),
				vfichaapertura.getDescripcionobracentro(),
				vfichaapertura.getAcompanaplanseguridad(),
				vfichaapertura.getNoacompanaplanseguridad(),
				vfichaapertura.getAdjuntaproyectotecnico(),
				vfichaapertura.getNoadjuntaproyectotecnico(),
				vfichaapertura.getMaquinariaherramientas(),
				vfichaapertura.getSuperficieconstruida(),
				vfichaapertura.getPotenciainstalada(),
				vfichaapertura.getTrabajoanexoi(),
				vfichaapertura.getNotrabajoanexoi(),
				vfichaapertura.getApartadoanexoi(),
				vfichaapertura.getApartadoanexoieus(),
				vfichaapertura.getFirma(), vfichaapertura.getCodobra(),
				vfichaapertura.getTipoobra(), vfichaapertura.getTipoobraeus(),
				vfichaapertura.getDirexactaobra(),
				vfichaapertura.getFechacomienzoobra(),
				vfichaapertura.getDuracionprevista(),
				vfichaapertura.getDuracionprevistacontratista(),
				vfichaapertura.getNumerocontratista(),
				vfichaapertura.getRealizatrabajos(),
				vfichaapertura.getNorealizatrabajos(),
				vfichaapertura.getTipoanexo2(),
				vfichaapertura.getDescripcionanexo2());
	}

	/**
	 * Finds a list of rows in the VfichaApertura table.
	 * 
	 * vfichaapertura VfichaApertura jqGridRequestDto JQGridRequestDto List
	 * <VfichaApertura>
	 * 
	 * @param vfichaapertura
	 *            the vfichaapertura
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<VfichaApertura> findAll(VfichaApertura vfichaapertura,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.NUMEXP NUMEXP,t1.PROVINCIACAST PROVINCIACAST,t1.PROVINCIAEUSK PROVINCIAEUSK,t1.ANIO ANIO,t1.DIA DIA,t1.MES MES,t1.MESEUS MESEUS,t1.EMPRESAEXISTENTE EMPRESAEXISTENTE,t1.EMPRESANOEXISTENTE EMPRESANOEXISTENTE,t1.NUMERODOCUMENTO NUMERODOCUMENTO,t1.RAZONSOCIAL RAZONSOCIAL,t1.DIRECCION DIRECCION,t1.MUNICIPIOEMPRESA MUNICIPIOEMPRESA,t1.TERRITORIOEMPRESA TERRITORIOEMPRESA,t1.CP CP,t1.TELEFONOEMPRESA TELEFONOEMPRESA,t1.ACTIVIDADECONOMICA ACTIVIDADECONOMICA,t1.ENTIDADGESTORACOLABORADORA ENTIDADGESTORACOLABORADORA,t1.NUEVOCENTRO NUEVOCENTRO,t1.REANUDACIONACTIVIDAD REANUDACIONACTIVIDAD,t1.CAMBIOACTIVIDAD CAMBIOACTIVIDAD,t1.TRASLADO TRASLADO,t1.CAMBIORAZONSOCIAL CAMBIORAZONSOCIAL,t1.NOMBRECENTRO NOMBRECENTRO,t1.MUNICIPIOCENTRO MUNICIPIOCENTRO,t1.PROVINCIACENTRO PROVINCIACENTRO,t1.DIRECCIONCENTRO DIRECCIONCENTRO,t1.ACTIVIDADECONOMICACENTRO ACTIVIDADECONOMICACENTRO,t1.FAXCENTRO FAXCENTRO,t1.EMAILCENTRO EMAILCENTRO,t1.TELEFONOCENTRO TELEFONOCENTRO,t1.CPCENTRO CPCENTRO,t1.DIAINICIOACTIVIDAD DIAINICIOACTIVIDAD,t1.MESINICIOACTIVIDAD MESINICIOACTIVIDAD,t1.ANIOINICIOACTIVIDAD ANIOINICIOACTIVIDAD,t1.NSSPROVCENTRO NSSPROVCENTRO,t1.NSSNUMCENTRO NSSNUMCENTRO,t1.NSSDIGCENTRO NSSDIGCENTRO,t1.TRABAJADORESHOMBRE TRABAJADORESHOMBRE,t1.TRABAJADORESMUJER TRABAJADORESMUJER,t1.TOTALTRABAJADORES TOTALTRABAJADORES, t1.NUMREGEMP NUMREGEMP,t1.CLASECENTRO CLASECENTRO,t1.CLASECENTROEUS CLASECENTROEUS,t1.DESCRIPCIONOBRACENTRO DESCRIPCIONOBRACENTRO,t1.ACOMPANAPLANSEGURIDAD ACOMPANAPLANSEGURIDAD,t1.NOACOMPANAPLANSEGURIDAD NOACOMPANAPLANSEGURIDAD,t1.ADJUNTAPROYECTOTECNICO ADJUNTAPROYECTOTECNICO,t1.NOADJUNTAPROYECTOTECNICO NOADJUNTAPROYECTOTECNICO, t1.MODALIDADORGANIZATIVA MODALIDADORGANIZATIVA, t1.MODALIDADORGANIZATIVADESC MODALIDADORGANIZATIVADESC, t1.MAQUINARIAHERRAMIENTAS MAQUINARIAHERRAMIENTAS,t1.SUPERFICIECONSTRUIDA SUPERFICIECONSTRUIDA,t1.POTENCIAINSTALADA POTENCIAINSTALADA,t1.TRABAJOANEXOI TRABAJOANEXOI,t1.NOTRABAJOANEXOI NOTRABAJOANEXOI,t1.APARTADOANEXOI APARTADOANEXOI,t1.APARTADOANEXOIEUS APARTADOANEXOIEUS,t1.FIRMA FIRMA,t1.CODOBRA CODOBRA,t1.TIPOOBRA TIPOOBRA,t1.TIPOOBRAEUS TIPOOBRAEUS,t1.DIREXACTAOBRA DIREXACTAOBRA,t1.FECHACOMIENZOOBRA FECHACOMIENZOOBRA, t1.NUMMAXTRABOBRA NUMMAXTRABOBRA, t1.DURACIONPREVISTA DURACIONPREVISTA,t1.DURACIONPREVISTACONTRATISTA DURACIONPREVISTACONTRATISTA,t1.NUMEROCONTRATISTA NUMEROCONTRATISTA,t1.REALIZATRABAJOS REALIZATRABAJOS,t1.NOREALIZATRABAJOS NOREALIZATRABAJOS,t1.TIPOANEXO2 TIPOANEXO2,t1.DESCRIPCIONANEXO2 DESCRIPCIONANEXO2 ");
		query.append("FROM VFICHA_APERTURA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(vfichaapertura);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<VfichaApertura>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the VfichaApertura table using like.
	 * 
	 * vfichaapertura VfichaApertura jqGridRequestDto JQGridRequestDto
	 * startsWith Boolean List<VfichaApertura>
	 * 
	 * @param vfichaapertura
	 *            the vfichaapertura
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<VfichaApertura> findAllLike(VfichaApertura vfichaapertura,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.NUMEXP NUMEXP,t1.PROVINCIACAST PROVINCIACAST,t1.PROVINCIAEUSK PROVINCIAEUSK,t1.ANIO ANIO,t1.DIA DIA,t1.MES MES,t1.MESEUS MESEUS,t1.EMPRESAEXISTENTE EMPRESAEXISTENTE,t1.EMPRESANOEXISTENTE EMPRESANOEXISTENTE,t1.NUMERODOCUMENTO NUMERODOCUMENTO,t1.RAZONSOCIAL RAZONSOCIAL,t1.DIRECCION DIRECCION,t1.MUNICIPIOEMPRESA MUNICIPIOEMPRESA,t1.TERRITORIOEMPRESA TERRITORIOEMPRESA,t1.CP CP,t1.TELEFONOEMPRESA TELEFONOEMPRESA,t1.ACTIVIDADECONOMICA ACTIVIDADECONOMICA,t1.ENTIDADGESTORACOLABORADORA ENTIDADGESTORACOLABORADORA,t1.NUEVOCENTRO NUEVOCENTRO,t1.REANUDACIONACTIVIDAD REANUDACIONACTIVIDAD,t1.CAMBIOACTIVIDAD CAMBIOACTIVIDAD,t1.TRASLADO TRASLADO,t1.CAMBIORAZONSOCIAL CAMBIORAZONSOCIAL,t1.NOMBRECENTRO NOMBRECENTRO,t1.MUNICIPIOCENTRO MUNICIPIOCENTRO,t1.PROVINCIACENTRO PROVINCIACENTRO,t1.DIRECCIONCENTRO DIRECCIONCENTRO,t1.ACTIVIDADECONOMICACENTRO ACTIVIDADECONOMICACENTRO,t1.FAXCENTRO FAXCENTRO,t1.EMAILCENTRO EMAILCENTRO,t1.TELEFONOCENTRO TELEFONOCENTRO,t1.CPCENTRO CPCENTRO,t1.DIAINICIOACTIVIDAD DIAINICIOACTIVIDAD,t1.MESINICIOACTIVIDAD MESINICIOACTIVIDAD,t1.ANIOINICIOACTIVIDAD ANIOINICIOACTIVIDAD,t1.NSSPROVCENTRO NSSPROVCENTRO,t1.NSSNUMCENTRO NSSNUMCENTRO,t1.NSSDIGCENTRO NSSDIGCENTRO,t1.TRABAJADORESHOMBRE TRABAJADORESHOMBRE,t1.TRABAJADORESMUJER TRABAJADORESMUJER,t1.TOTALTRABAJADORES TOTALTRABAJADORES, t1.NUMREGEMP NUMREGEMP, t1.CLASECENTRO CLASECENTRO,t1.CLASECENTROEUS CLASECENTROEUS,t1.DESCRIPCIONOBRACENTRO DESCRIPCIONOBRACENTRO,t1.ACOMPANAPLANSEGURIDAD ACOMPANAPLANSEGURIDAD,t1.NOACOMPANAPLANSEGURIDAD NOACOMPANAPLANSEGURIDAD,t1.ADJUNTAPROYECTOTECNICO ADJUNTAPROYECTOTECNICO,t1.NOADJUNTAPROYECTOTECNICO NOADJUNTAPROYECTOTECNICO, t1.MODALIDADORGANIZATIVA MODALIDADORGANIZATIVA, t1.MODALIDADORGANIZATIVADESC MODALIDADORGANIZATIVADESC,t1.MAQUINARIAHERRAMIENTAS MAQUINARIAHERRAMIENTAS,t1.SUPERFICIECONSTRUIDA SUPERFICIECONSTRUIDA,t1.POTENCIAINSTALADA POTENCIAINSTALADA,t1.TRABAJOANEXOI TRABAJOANEXOI,t1.NOTRABAJOANEXOI NOTRABAJOANEXOI,t1.APARTADOANEXOI APARTADOANEXOI,t1.APARTADOANEXOIEUS APARTADOANEXOIEUS,t1.FIRMA FIRMA,t1.CODOBRA CODOBRA,t1.TIPOOBRA TIPOOBRA,t1.TIPOOBRAEUS TIPOOBRAEUS,t1.DIREXACTAOBRA DIREXACTAOBRA,t1.FECHACOMIENZOOBRA FECHACOMIENZOOBRA,  t1.NUMMAXTRABOBRA NUMMAXTRABOBRA, t1.DURACIONPREVISTA DURACIONPREVISTA,t1.DURACIONPREVISTACONTRATISTA DURACIONPREVISTACONTRATISTA,t1.NUMEROCONTRATISTA NUMEROCONTRATISTA,t1.REALIZATRABAJOS REALIZATRABAJOS,t1.NOREALIZATRABAJOS NOREALIZATRABAJOS,t1.TIPOANEXO2 TIPOANEXO2,t1.DESCRIPCIONANEXO2 DESCRIPCIONANEXO2 ");
		query.append("FROM VFICHA_APERTURA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(vfichaapertura,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<VfichaApertura>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the VfichaApertura table.
	 * 
	 * vfichaapertura VfichaApertura Long
	 * 
	 * @param vfichaapertura
	 *            the vfichaapertura
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(VfichaApertura vfichaapertura) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM VFICHA_APERTURA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(vfichaapertura);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the VfichaApertura table using like.
	 * 
	 * vfichaapertura VfichaApertura startsWith Boolean Long
	 * 
	 * @param vfichaapertura
	 *            the vfichaapertura
	 * @param startsWith
	 *            the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(VfichaApertura vfichaapertura,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM VFICHA_APERTURA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(vfichaapertura,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of VfichaApertura selected for rup_table.
	 * 
	 * vfichaapertura VfichaApertura jqGridRequestDto JQGridRequestDto
	 * startsWith Boolean List<TableRowDto<VfichaApertura>>
	 * 
	 * @param vfichaapertura
	 *            the vfichaapertura
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<VfichaApertura>> reorderSelection(
			VfichaApertura vfichaapertura, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.NUMEXP NUMEXP,t1.PROVINCIACAST PROVINCIACAST,t1.PROVINCIAEUSK PROVINCIAEUSK,t1.ANIO ANIO,t1.DIA DIA,t1.MES MES,t1.MESEUS MESEUS,t1.EMPRESAEXISTENTE EMPRESAEXISTENTE,t1.EMPRESANOEXISTENTE EMPRESANOEXISTENTE,t1.NUMERODOCUMENTO NUMERODOCUMENTO,t1.RAZONSOCIAL RAZONSOCIAL,t1.DIRECCION DIRECCION,t1.MUNICIPIOEMPRESA MUNICIPIOEMPRESA,t1.TERRITORIOEMPRESA TERRITORIOEMPRESA,t1.CP CP,t1.TELEFONOEMPRESA TELEFONOEMPRESA,t1.ACTIVIDADECONOMICA ACTIVIDADECONOMICA,t1.ENTIDADGESTORACOLABORADORA ENTIDADGESTORACOLABORADORA,t1.NUEVOCENTRO NUEVOCENTRO,t1.REANUDACIONACTIVIDAD REANUDACIONACTIVIDAD,t1.CAMBIOACTIVIDAD CAMBIOACTIVIDAD,t1.TRASLADO TRASLADO,t1.NOMBRECENTRO NOMBRECENTRO,t1.MUNICIPIOCENTRO MUNICIPIOCENTRO,t1.PROVINCIACENTRO PROVINCIACENTRO,t1.DIRECCIONCENTRO DIRECCIONCENTRO,t1.ACTIVIDADECONOMICACENTRO ACTIVIDADECONOMICACENTRO,t1.FAXCENTRO FAXCENTRO,t1.TELEFONOCENTRO TELEFONOCENTRO,t1.CPCENTRO CPCENTRO,t1.DIAINICIOACTIVIDAD DIAINICIOACTIVIDAD,t1.MESINICIOACTIVIDAD MESINICIOACTIVIDAD,t1.ANIOINICIOACTIVIDAD ANIOINICIOACTIVIDAD,t1.NSSPROVCENTRO NSSPROVCENTRO,t1.NSSNUMCENTRO NSSNUMCENTRO,t1.NSSDIGCENTRO NSSDIGCENTRO,t1.TRABAJADORESHOMBRE TRABAJADORESHOMBRE,t1.TRABAJADORESMUJER TRABAJADORESMUJER,t1.TOTALTRABAJADORES TOTALTRABAJADORES,t1.CLASECENTRO CLASECENTRO,t1.CLASECENTROEUS CLASECENTROEUS,t1.DESCRIPCIONOBRACENTRO DESCRIPCIONOBRACENTRO,t1.ACOMPANAPLANSEGURIDAD ACOMPANAPLANSEGURIDAD,t1.NOACOMPANAPLANSEGURIDAD NOACOMPANAPLANSEGURIDAD,t1.ADJUNTAPROYECTOTECNICO ADJUNTAPROYECTOTECNICO,t1.NOADJUNTAPROYECTOTECNICO NOADJUNTAPROYECTOTECNICO,t1.MAQUINARIAHERRAMIENTAS MAQUINARIAHERRAMIENTAS,t1.SUPERFICIECONSTRUIDA SUPERFICIECONSTRUIDA,t1.POTENCIAINSTALADA POTENCIAINSTALADA,t1.TRABAJOANEXOI TRABAJOANEXOI,t1.NOTRABAJOANEXOI NOTRABAJOANEXOI,t1.APARTADOANEXOI APARTADOANEXOI,t1.APARTADOANEXOIEUS APARTADOANEXOIEUS,t1.FIRMA FIRMA,t1.CODOBRA CODOBRA,t1.TIPOOBRA TIPOOBRA,t1.TIPOOBRAEUS TIPOOBRAEUS,t1.DIREXACTAOBRA DIREXACTAOBRA,t1.FECHACOMIENZOOBRA FECHACOMIENZOOBRA,t1.DURACIONPREVISTA DURACIONPREVISTA,t1.DURACIONPREVISTACONTRATISTA DURACIONPREVISTACONTRATISTA,t1.NUMEROCONTRATISTA NUMEROCONTRATISTA,t1.REALIZATRABAJOS REALIZATRABAJOS,t1.NOREALIZATRABAJOS NOREALIZATRABAJOS,t1.TIPOANEXO2 TIPOANEXO2,t1.DESCRIPCIONANEXO2 DESCRIPCIONANEXO2 ");
		// FROM
		query.append("FROM VFICHA_APERTURA t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(vfichaapertura,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, VfichaApertura.class, filterParamList,
				"NUMEXP,PROVINCIACAST,PROVINCIAEUSK,ANIO,DIA,MES,MESEUS,EMPRESAEXISTENTE,EMPRESANOEXISTENTE,NUMERODOCUMENTO,RAZONSOCIAL,DIRECCION,MUNICIPIOEMPRESA,TERRITORIOEMPRESA,CP,TELEFONOEMPRESA,ACTIVIDADECONOMICA,ENTIDADGESTORACOLABORADORA,NUEVOCENTRO,REANUDACIONACTIVIDAD,CAMBIOACTIVIDAD,TRASLADO,NOMBRECENTRO,MUNICIPIOCENTRO,PROVINCIACENTRO,DIRECCIONCENTRO,ACTIVIDADECONOMICACENTRO,FAXCENTRO,TELEFONOCENTRO,CPCENTRO,DIAINICIOACTIVIDAD,MESINICIOACTIVIDAD,ANIOINICIOACTIVIDAD,NSSPROVCENTRO,NSSNUMCENTRO,NSSDIGCENTRO,TRABAJADORESHOMBRE,TRABAJADORESMUJER,TOTALTRABAJADORES,CLASECENTRO,CLASECENTROEUS,DESCRIPCIONOBRACENTRO,ACOMPANAPLANSEGURIDAD,NOACOMPANAPLANSEGURIDAD,ADJUNTAPROYECTOTECNICO,NOADJUNTAPROYECTOTECNICO,MAQUINARIAHERRAMIENTAS,SUPERFICIECONSTRUIDA,POTENCIAINSTALADA,TRABAJOANEXOI,NOTRABAJOANEXOI,APARTADOANEXOI,APARTADOANEXOIEUS,FIRMA,CODOBRA,TIPOOBRA,TIPOOBRAEUS,DIREXACTAOBRA,FECHACOMIENZOOBRA,DURACIONPREVISTA,DURACIONPREVISTACONTRATISTA,NUMEROCONTRATISTA,REALIZATRABAJOS,NOREALIZATRABAJOS,TIPOANEXO2,DESCRIPCIONANEXO2");

		return this.jdbcTemplate
				.query(sbReorderSelectionSQL.toString(),
						new RowNumResultSetExtractor<VfichaApertura>(
								this.rwMapPK, jqGridRequestDto),
						filterParamList.toArray());
	}

	/**
	 * Search method for rup_table.
	 * 
	 * filterParams VfichaApertura searchParams VfichaApertura jqGridRequestDto
	 * JQGridRequestDto startsWith Boolean List<TableRowDto<VfichaApertura>>
	 * 
	 * @param filterParams
	 *            the filter params
	 * @param searchParams
	 *            the search params
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<VfichaApertura>> search(VfichaApertura filterParams,
			VfichaApertura searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.NUMEXP NUMEXP,t1.PROVINCIACAST PROVINCIACAST,t1.PROVINCIAEUSK PROVINCIAEUSK,t1.ANIO ANIO,t1.DIA DIA,t1.MES MES,t1.MESEUS MESEUS,t1.EMPRESAEXISTENTE EMPRESAEXISTENTE,t1.EMPRESANOEXISTENTE EMPRESANOEXISTENTE,t1.NUMERODOCUMENTO NUMERODOCUMENTO,t1.RAZONSOCIAL RAZONSOCIAL,t1.DIRECCION DIRECCION,t1.MUNICIPIOEMPRESA MUNICIPIOEMPRESA,t1.TERRITORIOEMPRESA TERRITORIOEMPRESA,t1.CP CP,t1.TELEFONOEMPRESA TELEFONOEMPRESA,t1.ACTIVIDADECONOMICA ACTIVIDADECONOMICA,t1.ENTIDADGESTORACOLABORADORA ENTIDADGESTORACOLABORADORA,t1.NUEVOCENTRO NUEVOCENTRO,t1.REANUDACIONACTIVIDAD REANUDACIONACTIVIDAD,t1.CAMBIOACTIVIDAD CAMBIOACTIVIDAD,t1.TRASLADO TRASLADO,t1.NOMBRECENTRO NOMBRECENTRO,t1.MUNICIPIOCENTRO MUNICIPIOCENTRO,t1.PROVINCIACENTRO PROVINCIACENTRO,t1.DIRECCIONCENTRO DIRECCIONCENTRO,t1.ACTIVIDADECONOMICACENTRO ACTIVIDADECONOMICACENTRO,t1.FAXCENTRO FAXCENTRO,t1.TELEFONOCENTRO TELEFONOCENTRO,t1.CPCENTRO CPCENTRO,t1.DIAINICIOACTIVIDAD DIAINICIOACTIVIDAD,t1.MESINICIOACTIVIDAD MESINICIOACTIVIDAD,t1.ANIOINICIOACTIVIDAD ANIOINICIOACTIVIDAD,t1.NSSPROVCENTRO NSSPROVCENTRO,t1.NSSNUMCENTRO NSSNUMCENTRO,t1.NSSDIGCENTRO NSSDIGCENTRO,t1.TRABAJADORESHOMBRE TRABAJADORESHOMBRE,t1.TRABAJADORESMUJER TRABAJADORESMUJER,t1.TOTALTRABAJADORES TOTALTRABAJADORES,t1.CLASECENTRO CLASECENTRO,t1.CLASECENTROEUS CLASECENTROEUS,t1.DESCRIPCIONOBRACENTRO DESCRIPCIONOBRACENTRO,t1.ACOMPANAPLANSEGURIDAD ACOMPANAPLANSEGURIDAD,t1.NOACOMPANAPLANSEGURIDAD NOACOMPANAPLANSEGURIDAD,t1.ADJUNTAPROYECTOTECNICO ADJUNTAPROYECTOTECNICO,t1.NOADJUNTAPROYECTOTECNICO NOADJUNTAPROYECTOTECNICO,t1.MAQUINARIAHERRAMIENTAS MAQUINARIAHERRAMIENTAS,t1.SUPERFICIECONSTRUIDA SUPERFICIECONSTRUIDA,t1.POTENCIAINSTALADA POTENCIAINSTALADA,t1.TRABAJOANEXOI TRABAJOANEXOI,t1.NOTRABAJOANEXOI NOTRABAJOANEXOI,t1.APARTADOANEXOI APARTADOANEXOI,t1.APARTADOANEXOIEUS APARTADOANEXOIEUS,t1.FIRMA FIRMA,t1.CODOBRA CODOBRA,t1.TIPOOBRA TIPOOBRA,t1.TIPOOBRAEUS TIPOOBRAEUS,t1.DIREXACTAOBRA DIREXACTAOBRA,t1.FECHACOMIENZOOBRA FECHACOMIENZOOBRA,t1.DURACIONPREVISTA DURACIONPREVISTA,t1.DURACIONPREVISTACONTRATISTA DURACIONPREVISTACONTRATISTA,t1.NUMEROCONTRATISTA NUMEROCONTRATISTA,t1.REALIZATRABAJOS REALIZATRABAJOS,t1.NOREALIZATRABAJOS NOREALIZATRABAJOS,t1.TIPOANEXO2 TIPOANEXO2,t1.DESCRIPCIONANEXO2 DESCRIPCIONANEXO2 ");
		// FROM
		query.append("FROM VFICHA_APERTURA t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams,
				startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, VfichaApertura.class, filterParamList,
				searchSQL, searchParamList, from_alias,
				"NUMEXP,PROVINCIACAST,PROVINCIAEUSK,ANIO,DIA,MES,MESEUS,EMPRESAEXISTENTE,EMPRESANOEXISTENTE,NUMERODOCUMENTO,RAZONSOCIAL,DIRECCION,MUNICIPIOEMPRESA,TERRITORIOEMPRESA,CP,TELEFONOEMPRESA,ACTIVIDADECONOMICA,ENTIDADGESTORACOLABORADORA,NUEVOCENTRO,REANUDACIONACTIVIDAD,CAMBIOACTIVIDAD,TRASLADO,NOMBRECENTRO,MUNICIPIOCENTRO,PROVINCIACENTRO,DIRECCIONCENTRO,ACTIVIDADECONOMICACENTRO,FAXCENTRO,TELEFONOCENTRO,CPCENTRO,DIAINICIOACTIVIDAD,MESINICIOACTIVIDAD,ANIOINICIOACTIVIDAD,NSSPROVCENTRO,NSSNUMCENTRO,NSSDIGCENTRO,TRABAJADORESHOMBRE,TRABAJADORESMUJER,TOTALTRABAJADORES,CLASECENTRO,CLASECENTROEUS,DESCRIPCIONOBRACENTRO,ACOMPANAPLANSEGURIDAD,NOACOMPANAPLANSEGURIDAD,ADJUNTAPROYECTOTECNICO,NOADJUNTAPROYECTOTECNICO,MAQUINARIAHERRAMIENTAS,SUPERFICIECONSTRUIDA,POTENCIAINSTALADA,TRABAJOANEXOI,NOTRABAJOANEXOI,APARTADOANEXOI,APARTADOANEXOIEUS,FIRMA,CODOBRA,TIPOOBRA,TIPOOBRAEUS,DIREXACTAOBRA,FECHACOMIENZOOBRA,DURACIONPREVISTA,DURACIONPREVISTACONTRATISTA,NUMEROCONTRATISTA,REALIZATRABAJOS,NOREALIZATRABAJOS,TIPOANEXO2,DESCRIPCIONANEXO2");

		return this.jdbcTemplate
				.query(sbReorderSelectionSQL.toString(),
						new RowNumResultSetExtractor<VfichaApertura>(
								this.rwMapPK, jqGridRequestDto),
						filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table.
	 * 
	 * filtervfichaapertura VfichaApertura jqGridRequestDto JQGridRequestDto
	 * startsWith Boolean
	 * 
	 * @param filtervfichaapertura
	 *            the filtervfichaapertura
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 */
	@Override
	public void removeMultiple(VfichaApertura filtervfichaapertura,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.NUMEXP NUMEXP,t1.PROVINCIACAST PROVINCIACAST,t1.PROVINCIAEUSK PROVINCIAEUSK,t1.ANIO ANIO,t1.DIA DIA,t1.MES MES,t1.MESEUS MESEUS,t1.EMPRESAEXISTENTE EMPRESAEXISTENTE,t1.EMPRESANOEXISTENTE EMPRESANOEXISTENTE,t1.NUMERODOCUMENTO NUMERODOCUMENTO,t1.RAZONSOCIAL RAZONSOCIAL,t1.DIRECCION DIRECCION,t1.MUNICIPIOEMPRESA MUNICIPIOEMPRESA,t1.TERRITORIOEMPRESA TERRITORIOEMPRESA,t1.CP CP,t1.TELEFONOEMPRESA TELEFONOEMPRESA,t1.ACTIVIDADECONOMICA ACTIVIDADECONOMICA,t1.ENTIDADGESTORACOLABORADORA ENTIDADGESTORACOLABORADORA,t1.NUEVOCENTRO NUEVOCENTRO,t1.REANUDACIONACTIVIDAD REANUDACIONACTIVIDAD,t1.CAMBIOACTIVIDAD CAMBIOACTIVIDAD,t1.TRASLADO TRASLADO,t1.NOMBRECENTRO NOMBRECENTRO,t1.MUNICIPIOCENTRO MUNICIPIOCENTRO,t1.PROVINCIACENTRO PROVINCIACENTRO,t1.DIRECCIONCENTRO DIRECCIONCENTRO,t1.ACTIVIDADECONOMICACENTRO ACTIVIDADECONOMICACENTRO,t1.FAXCENTRO FAXCENTRO,t1.TELEFONOCENTRO TELEFONOCENTRO,t1.CPCENTRO CPCENTRO,t1.DIAINICIOACTIVIDAD DIAINICIOACTIVIDAD,t1.MESINICIOACTIVIDAD MESINICIOACTIVIDAD,t1.ANIOINICIOACTIVIDAD ANIOINICIOACTIVIDAD,t1.NSSPROVCENTRO NSSPROVCENTRO,t1.NSSNUMCENTRO NSSNUMCENTRO,t1.NSSDIGCENTRO NSSDIGCENTRO,t1.TRABAJADORESHOMBRE TRABAJADORESHOMBRE,t1.TRABAJADORESMUJER TRABAJADORESMUJER,t1.TOTALTRABAJADORES TOTALTRABAJADORES,t1.CLASECENTRO CLASECENTRO,t1.CLASECENTROEUS CLASECENTROEUS,t1.DESCRIPCIONOBRACENTRO DESCRIPCIONOBRACENTRO,t1.ACOMPANAPLANSEGURIDAD ACOMPANAPLANSEGURIDAD,t1.NOACOMPANAPLANSEGURIDAD NOACOMPANAPLANSEGURIDAD,t1.ADJUNTAPROYECTOTECNICO ADJUNTAPROYECTOTECNICO,t1.NOADJUNTAPROYECTOTECNICO NOADJUNTAPROYECTOTECNICO,t1.MAQUINARIAHERRAMIENTAS MAQUINARIAHERRAMIENTAS,t1.SUPERFICIECONSTRUIDA SUPERFICIECONSTRUIDA,t1.POTENCIAINSTALADA POTENCIAINSTALADA,t1.TRABAJOANEXOI TRABAJOANEXOI,t1.NOTRABAJOANEXOI NOTRABAJOANEXOI,t1.APARTADOANEXOI APARTADOANEXOI,t1.APARTADOANEXOIEUS APARTADOANEXOIEUS,t1.FIRMA FIRMA,t1.CODOBRA CODOBRA,t1.TIPOOBRA TIPOOBRA,t1.TIPOOBRAEUS TIPOOBRAEUS,t1.DIREXACTAOBRA DIREXACTAOBRA,t1.FECHACOMIENZOOBRA FECHACOMIENZOOBRA,t1.DURACIONPREVISTA DURACIONPREVISTA,t1.DURACIONPREVISTACONTRATISTA DURACIONPREVISTACONTRATISTA,t1.NUMEROCONTRATISTA NUMEROCONTRATISTA,t1.REALIZATRABAJOS REALIZATRABAJOS,t1.NOREALIZATRABAJOS NOREALIZATRABAJOS,t1.TIPOANEXO2 TIPOANEXO2,t1.DESCRIPCIONANEXO2 DESCRIPCIONANEXO2 ");
		// FROM
		query.append("FROM VFICHA_APERTURA t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this
				.getWhereLikeMap(filtervfichaapertura, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto, VfichaApertura.class,
						query, params,
						"NUMEXP,PROVINCIACAST,PROVINCIAEUSK,ANIO,DIA,MES,MESEUS,EMPRESAEXISTENTE,EMPRESANOEXISTENTE,NUMERODOCUMENTO,RAZONSOCIAL,DIRECCION,MUNICIPIOEMPRESA,TERRITORIOEMPRESA,CP,TELEFONOEMPRESA,ACTIVIDADECONOMICA,ENTIDADGESTORACOLABORADORA,NUEVOCENTRO,REANUDACIONACTIVIDAD,CAMBIOACTIVIDAD,TRASLADO,NOMBRECENTRO,MUNICIPIOCENTRO,PROVINCIACENTRO,DIRECCIONCENTRO,ACTIVIDADECONOMICACENTRO,FAXCENTRO,TELEFONOCENTRO,CPCENTRO,DIAINICIOACTIVIDAD,MESINICIOACTIVIDAD,ANIOINICIOACTIVIDAD,NSSPROVCENTRO,NSSNUMCENTRO,NSSDIGCENTRO,TRABAJADORESHOMBRE,TRABAJADORESMUJER,TOTALTRABAJADORES,CLASECENTRO,CLASECENTROEUS,DESCRIPCIONOBRACENTRO,ACOMPANAPLANSEGURIDAD,NOACOMPANAPLANSEGURIDAD,ADJUNTAPROYECTOTECNICO,NOADJUNTAPROYECTOTECNICO,MAQUINARIAHERRAMIENTAS,SUPERFICIECONSTRUIDA,POTENCIAINSTALADA,TRABAJOANEXOI,NOTRABAJOANEXOI,APARTADOANEXOI,APARTADOANEXOIEUS,FIRMA,CODOBRA,TIPOOBRA,TIPOOBRAEUS,DIREXACTAOBRA,FECHACOMIENZOOBRA,DURACIONPREVISTA,DURACIONPREVISTACONTRATISTA,NUMEROCONTRATISTA,REALIZATRABAJOS,NOREALIZATRABAJOS,TIPOANEXO2,DESCRIPCIONANEXO2");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the VfichaApertura entity.
	 * 
	 * vfichaapertura VfichaApertura Bean with the criteria values to filter by.
	 * Map created with two keys key query stores the sql query syntax key
	 * params stores the parameter values to be used in the condition sentence.
	 * 
	 * @param vfichaapertura
	 *            the vfichaapertura
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(VfichaApertura vfichaapertura) {

		StringBuilder where = new StringBuilder(
				VfichaAperturaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (vfichaapertura != null && vfichaapertura.getNumexp() != null) {
			where.append(" AND t1.NUMEXP = ?");
			params.add(vfichaapertura.getNumexp());
		}
		if (vfichaapertura != null
				&& vfichaapertura.getProvinciacast() != null) {
			where.append(" AND t1.PROVINCIACAST = ?");
			params.add(vfichaapertura.getProvinciacast());
		}
		if (vfichaapertura != null
				&& vfichaapertura.getProvinciaeusk() != null) {
			where.append(" AND t1.PROVINCIAEUSK = ?");
			params.add(vfichaapertura.getProvinciaeusk());
		}
		if (vfichaapertura != null && vfichaapertura.getAnio() != null) {
			where.append(" AND t1.ANIO = ?");
			params.add(vfichaapertura.getAnio());
		}
		if (vfichaapertura != null && vfichaapertura.getDia() != null) {
			where.append(" AND t1.DIA = ?");
			params.add(vfichaapertura.getDia());
		}
		if (vfichaapertura != null && vfichaapertura.getMes() != null) {
			where.append(" AND t1.MES = ?");
			params.add(vfichaapertura.getMes());
		}
		if (vfichaapertura != null && vfichaapertura.getMeseus() != null) {
			where.append(" AND t1.MESEUS = ?");
			params.add(vfichaapertura.getMeseus());
		}
		if (vfichaapertura != null
				&& vfichaapertura.getEmpresaexistente() != null) {
			where.append(" AND t1.EMPRESAEXISTENTE = ?");
			params.add(vfichaapertura.getEmpresaexistente());
		}
		if (vfichaapertura != null
				&& vfichaapertura.getEmpresanoexistente() != null) {
			where.append(" AND t1.EMPRESANOEXISTENTE = ?");
			params.add(vfichaapertura.getEmpresanoexistente());
		}
		if (vfichaapertura != null
				&& vfichaapertura.getNumerodocumento() != null) {
			where.append(" AND t1.NUMERODOCUMENTO = ?");
			params.add(vfichaapertura.getNumerodocumento());
		}
		if (vfichaapertura != null && vfichaapertura.getRazonsocial() != null) {
			where.append(" AND t1.RAZONSOCIAL = ?");
			params.add(vfichaapertura.getRazonsocial());
		}
		if (vfichaapertura != null && vfichaapertura.getDireccion() != null) {
			where.append(" AND t1.DIRECCION = ?");
			params.add(vfichaapertura.getDireccion());
		}
		if (vfichaapertura != null
				&& vfichaapertura.getMunicipioempresa() != null) {
			where.append(" AND t1.MUNICIPIOEMPRESA = ?");
			params.add(vfichaapertura.getMunicipioempresa());
		}
		if (vfichaapertura != null
				&& vfichaapertura.getTerritorioempresa() != null) {
			where.append(" AND t1.TERRITORIOEMPRESA = ?");
			params.add(vfichaapertura.getTerritorioempresa());
		}
		if (vfichaapertura != null && vfichaapertura.getCp() != null) {
			where.append(" AND t1.CP = ?");
			params.add(vfichaapertura.getCp());
		}
		if (vfichaapertura != null
				&& vfichaapertura.getTelefonoempresa() != null) {
			where.append(" AND t1.TELEFONOEMPRESA = ?");
			params.add(vfichaapertura.getTelefonoempresa());
		}
		if (vfichaapertura != null
				&& vfichaapertura.getActividadeconomica() != null) {
			where.append(" AND t1.ACTIVIDADECONOMICA = ?");
			params.add(vfichaapertura.getActividadeconomica());
		}
		if (vfichaapertura != null
				&& vfichaapertura.getEntidadgestoracolaboradora() != null) {
			where.append(" AND t1.ENTIDADGESTORACOLABORADORA = ?");
			params.add(vfichaapertura.getEntidadgestoracolaboradora());
		}
		if (vfichaapertura != null && vfichaapertura.getNuevocentro() != null) {
			where.append(" AND t1.NUEVOCENTRO = ?");
			params.add(vfichaapertura.getNuevocentro());
		}
		if (vfichaapertura != null
				&& vfichaapertura.getReanudacionactividad() != null) {
			where.append(" AND t1.REANUDACIONACTIVIDAD = ?");
			params.add(vfichaapertura.getReanudacionactividad());
		}
		if (vfichaapertura != null
				&& vfichaapertura.getCambioactividad() != null) {
			where.append(" AND t1.CAMBIOACTIVIDAD = ?");
			params.add(vfichaapertura.getCambioactividad());
		}
		if (vfichaapertura != null && vfichaapertura.getTraslado() != null) {
			where.append(" AND t1.TRASLADO = ?");
			params.add(vfichaapertura.getTraslado());
		}
		if (vfichaapertura != null
				&& vfichaapertura.getNombrecentro() != null) {
			where.append(" AND t1.NOMBRECENTRO = ?");
			params.add(vfichaapertura.getNombrecentro());
		}
		if (vfichaapertura != null
				&& vfichaapertura.getMunicipiocentro() != null) {
			where.append(" AND t1.MUNICIPIOCENTRO = ?");
			params.add(vfichaapertura.getMunicipiocentro());
		}
		if (vfichaapertura != null
				&& vfichaapertura.getProvinciacentro() != null) {
			where.append(" AND t1.PROVINCIACENTRO = ?");
			params.add(vfichaapertura.getProvinciacentro());
		}
		if (vfichaapertura != null
				&& vfichaapertura.getDireccioncentro() != null) {
			where.append(" AND t1.DIRECCIONCENTRO = ?");
			params.add(vfichaapertura.getDireccioncentro());
		}
		if (vfichaapertura != null
				&& vfichaapertura.getActividadeconomicacentro() != null) {
			where.append(" AND t1.ACTIVIDADECONOMICACENTRO = ?");
			params.add(vfichaapertura.getActividadeconomicacentro());
		}
		if (vfichaapertura != null && vfichaapertura.getFaxcentro() != null) {
			where.append(" AND t1.FAXCENTRO = ?");
			params.add(vfichaapertura.getFaxcentro());
		}
		if (vfichaapertura != null
				&& vfichaapertura.getTelefonocentro() != null) {
			where.append(" AND t1.TELEFONOCENTRO = ?");
			params.add(vfichaapertura.getTelefonocentro());
		}
		if (vfichaapertura != null && vfichaapertura.getCpcentro() != null) {
			where.append(" AND t1.CPCENTRO = ?");
			params.add(vfichaapertura.getCpcentro());
		}
		if (vfichaapertura != null
				&& vfichaapertura.getDiainicioactividad() != null) {
			where.append(" AND t1.DIAINICIOACTIVIDAD = ?");
			params.add(vfichaapertura.getDiainicioactividad());
		}
		if (vfichaapertura != null
				&& vfichaapertura.getMesinicioactividad() != null) {
			where.append(" AND t1.MESINICIOACTIVIDAD = ?");
			params.add(vfichaapertura.getMesinicioactividad());
		}
		if (vfichaapertura != null
				&& vfichaapertura.getAnioinicioactividad() != null) {
			where.append(" AND t1.ANIOINICIOACTIVIDAD = ?");
			params.add(vfichaapertura.getAnioinicioactividad());
		}
		if (vfichaapertura != null
				&& vfichaapertura.getNssprovcentro() != null) {
			where.append(" AND t1.NSSPROVCENTRO = ?");
			params.add(vfichaapertura.getNssprovcentro());
		}
		if (vfichaapertura != null
				&& vfichaapertura.getNssnumcentro() != null) {
			where.append(" AND t1.NSSNUMCENTRO = ?");
			params.add(vfichaapertura.getNssnumcentro());
		}
		if (vfichaapertura != null
				&& vfichaapertura.getNssdigcentro() != null) {
			where.append(" AND t1.NSSDIGCENTRO = ?");
			params.add(vfichaapertura.getNssdigcentro());
		}
		if (vfichaapertura != null
				&& vfichaapertura.getTrabajadoreshombre() != null) {
			where.append(" AND t1.TRABAJADORESHOMBRE = ?");
			params.add(vfichaapertura.getTrabajadoreshombre());
		}
		if (vfichaapertura != null
				&& vfichaapertura.getTrabajadoresmujer() != null) {
			where.append(" AND t1.TRABAJADORESMUJER = ?");
			params.add(vfichaapertura.getTrabajadoresmujer());
		}
		if (vfichaapertura != null
				&& vfichaapertura.getTotaltrabajadores() != null) {
			where.append(" AND t1.TOTALTRABAJADORES = ?");
			params.add(vfichaapertura.getTotaltrabajadores());
		}
		if (vfichaapertura != null && vfichaapertura.getClasecentro() != null) {
			where.append(" AND t1.CLASECENTRO = ?");
			params.add(vfichaapertura.getClasecentro());
		}
		if (vfichaapertura != null
				&& vfichaapertura.getClasecentroeus() != null) {
			where.append(" AND t1.CLASECENTROEUS = ?");
			params.add(vfichaapertura.getClasecentroeus());
		}
		if (vfichaapertura != null
				&& vfichaapertura.getDescripcionobracentro() != null) {
			where.append(" AND t1.DESCRIPCIONOBRACENTRO = ?");
			params.add(vfichaapertura.getDescripcionobracentro());
		}
		if (vfichaapertura != null
				&& vfichaapertura.getAcompanaplanseguridad() != null) {
			where.append(" AND t1.ACOMPANAPLANSEGURIDAD = ?");
			params.add(vfichaapertura.getAcompanaplanseguridad());
		}
		if (vfichaapertura != null
				&& vfichaapertura.getNoacompanaplanseguridad() != null) {
			where.append(" AND t1.NOACOMPANAPLANSEGURIDAD = ?");
			params.add(vfichaapertura.getNoacompanaplanseguridad());
		}
		if (vfichaapertura != null
				&& vfichaapertura.getAdjuntaproyectotecnico() != null) {
			where.append(" AND t1.ADJUNTAPROYECTOTECNICO = ?");
			params.add(vfichaapertura.getAdjuntaproyectotecnico());
		}
		if (vfichaapertura != null
				&& vfichaapertura.getNoadjuntaproyectotecnico() != null) {
			where.append(" AND t1.NOADJUNTAPROYECTOTECNICO = ?");
			params.add(vfichaapertura.getNoadjuntaproyectotecnico());
		}
		if (vfichaapertura != null
				&& vfichaapertura.getMaquinariaherramientas() != null) {
			where.append(" AND t1.MAQUINARIAHERRAMIENTAS = ?");
			params.add(vfichaapertura.getMaquinariaherramientas());
		}
		if (vfichaapertura != null
				&& vfichaapertura.getSuperficieconstruida() != null) {
			where.append(" AND t1.SUPERFICIECONSTRUIDA = ?");
			params.add(vfichaapertura.getSuperficieconstruida());
		}
		if (vfichaapertura != null
				&& vfichaapertura.getPotenciainstalada() != null) {
			where.append(" AND t1.POTENCIAINSTALADA = ?");
			params.add(vfichaapertura.getPotenciainstalada());
		}
		if (vfichaapertura != null
				&& vfichaapertura.getTrabajoanexoi() != null) {
			where.append(" AND t1.TRABAJOANEXOI = ?");
			params.add(vfichaapertura.getTrabajoanexoi());
		}
		if (vfichaapertura != null
				&& vfichaapertura.getNotrabajoanexoi() != null) {
			where.append(" AND t1.NOTRABAJOANEXOI = ?");
			params.add(vfichaapertura.getNotrabajoanexoi());
		}
		if (vfichaapertura != null
				&& vfichaapertura.getApartadoanexoi() != null) {
			where.append(" AND t1.APARTADOANEXOI = ?");
			params.add(vfichaapertura.getApartadoanexoi());
		}
		if (vfichaapertura != null
				&& vfichaapertura.getApartadoanexoieus() != null) {
			where.append(" AND t1.APARTADOANEXOIEUS = ?");
			params.add(vfichaapertura.getApartadoanexoieus());
		}
		if (vfichaapertura != null && vfichaapertura.getFirma() != null) {
			where.append(" AND t1.FIRMA = ?");
			params.add(vfichaapertura.getFirma());
		}
		if (vfichaapertura != null && vfichaapertura.getCodobra() != null) {
			where.append(" AND t1.CODOBRA = ?");
			params.add(vfichaapertura.getCodobra());
		}
		if (vfichaapertura != null && vfichaapertura.getTipoobra() != null) {
			where.append(" AND t1.TIPOOBRA = ?");
			params.add(vfichaapertura.getTipoobra());
		}
		if (vfichaapertura != null && vfichaapertura.getTipoobraeus() != null) {
			where.append(" AND t1.TIPOOBRAEUS = ?");
			params.add(vfichaapertura.getTipoobraeus());
		}
		if (vfichaapertura != null
				&& vfichaapertura.getDirexactaobra() != null) {
			where.append(" AND t1.DIREXACTAOBRA = ?");
			params.add(vfichaapertura.getDirexactaobra());
		}
		if (vfichaapertura != null
				&& vfichaapertura.getFechacomienzoobra() != null) {
			where.append(" AND t1.FECHACOMIENZOOBRA = ?");
			params.add(vfichaapertura.getFechacomienzoobra());
		}
		if (vfichaapertura != null
				&& vfichaapertura.getDuracionprevista() != null) {
			where.append(" AND t1.DURACIONPREVISTA = ?");
			params.add(vfichaapertura.getDuracionprevista());
		}
		if (vfichaapertura != null
				&& vfichaapertura.getDuracionprevistacontratista() != null) {
			where.append(" AND t1.DURACIONPREVISTACONTRATISTA = ?");
			params.add(vfichaapertura.getDuracionprevistacontratista());
		}
		if (vfichaapertura != null
				&& vfichaapertura.getNumerocontratista() != null) {
			where.append(" AND t1.NUMEROCONTRATISTA = ?");
			params.add(vfichaapertura.getNumerocontratista());
		}
		if (vfichaapertura != null
				&& vfichaapertura.getRealizatrabajos() != null) {
			where.append(" AND t1.REALIZATRABAJOS = ?");
			params.add(vfichaapertura.getRealizatrabajos());
		}
		if (vfichaapertura != null
				&& vfichaapertura.getNorealizatrabajos() != null) {
			where.append(" AND t1.NOREALIZATRABAJOS = ?");
			params.add(vfichaapertura.getNorealizatrabajos());
		}
		if (vfichaapertura != null && vfichaapertura.getTipoanexo2() != null) {
			where.append(" AND t1.TIPOANEXO2 = ?");
			params.add(vfichaapertura.getTipoanexo2());
		}
		if (vfichaapertura != null
				&& vfichaapertura.getDescripcionanexo2() != null) {
			where.append(" AND t1.DESCRIPCIONANEXO2 = ?");
			params.add(vfichaapertura.getDescripcionanexo2());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the VfichaApertura entity.
	 * 
	 * vfichaapertura VfichaApertura Bean with the criteria values to filter by.
	 * startsWith Boolean Map created with two keys key query stores the sql
	 * query syntax key params stores the parameter values to be used in the
	 * condition sentence.
	 * 
	 * @param vfichaapertura
	 *            the vfichaapertura
	 * @param startsWith
	 *            the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(VfichaApertura vfichaapertura,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				VfichaAperturaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (vfichaapertura != null && vfichaapertura.getNumexp() != null) {
			where.append(" AND UPPER(t1.NUMEXP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaapertura.getNumexp().toUpperCase() + "%");
			} else {
				params.add(
						"%" + vfichaapertura.getNumexp().toUpperCase() + "%");
			}
			where.append(" AND t1.NUMEXP IS NOT NULL");
		}
		if (vfichaapertura != null
				&& vfichaapertura.getProvinciacast() != null) {
			where.append(" AND UPPER(t1.PROVINCIACAST) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(
						vfichaapertura.getProvinciacast().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaapertura.getProvinciacast().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.PROVINCIACAST IS NOT NULL");
		}
		if (vfichaapertura != null
				&& vfichaapertura.getProvinciaeusk() != null) {
			where.append(" AND UPPER(t1.PROVINCIAEUSK) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(
						vfichaapertura.getProvinciaeusk().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaapertura.getProvinciaeusk().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.PROVINCIAEUSK IS NOT NULL");
		}
		if (vfichaapertura != null && vfichaapertura.getAnio() != null) {
			where.append(" AND UPPER(t1.ANIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaapertura.getAnio().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaapertura.getAnio().toUpperCase() + "%");
			}
			where.append(" AND t1.ANIO IS NOT NULL");
		}
		if (vfichaapertura != null && vfichaapertura.getDia() != null) {
			where.append(" AND UPPER(t1.DIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaapertura.getDia().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaapertura.getDia().toUpperCase() + "%");
			}
			where.append(" AND t1.DIA IS NOT NULL");
		}
		if (vfichaapertura != null && vfichaapertura.getMes() != null) {
			where.append(" AND UPPER(t1.MES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaapertura.getMes().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaapertura.getMes().toUpperCase() + "%");
			}
			where.append(" AND t1.MES IS NOT NULL");
		}
		if (vfichaapertura != null && vfichaapertura.getMeseus() != null) {
			where.append(" AND UPPER(t1.MESEUS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaapertura.getMeseus().toUpperCase() + "%");
			} else {
				params.add(
						"%" + vfichaapertura.getMeseus().toUpperCase() + "%");
			}
			where.append(" AND t1.MESEUS IS NOT NULL");
		}
		if (vfichaapertura != null
				&& vfichaapertura.getEmpresaexistente() != null) {
			where.append(" AND UPPER(t1.EMPRESAEXISTENTE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaapertura.getEmpresaexistente().toUpperCase()
						+ "%");
			} else {
				params.add(
						"%" + vfichaapertura.getEmpresaexistente().toUpperCase()
								+ "%");
			}
			where.append(" AND t1.EMPRESAEXISTENTE IS NOT NULL");
		}
		if (vfichaapertura != null
				&& vfichaapertura.getEmpresanoexistente() != null) {
			where.append(
					" AND UPPER(t1.EMPRESANOEXISTENTE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaapertura.getEmpresanoexistente().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ vfichaapertura.getEmpresanoexistente().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.EMPRESANOEXISTENTE IS NOT NULL");
		}
		if (vfichaapertura != null
				&& vfichaapertura.getNumerodocumento() != null) {
			where.append(" AND UPPER(t1.NUMERODOCUMENTO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaapertura.getNumerodocumento().toUpperCase()
						+ "%");
			} else {
				params.add(
						"%" + vfichaapertura.getNumerodocumento().toUpperCase()
								+ "%");
			}
			where.append(" AND t1.NUMERODOCUMENTO IS NOT NULL");
		}
		if (vfichaapertura != null && vfichaapertura.getRazonsocial() != null) {
			where.append(" AND UPPER(t1.RAZONSOCIAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaapertura.getRazonsocial().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaapertura.getRazonsocial().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.RAZONSOCIAL IS NOT NULL");
		}
		if (vfichaapertura != null && vfichaapertura.getDireccion() != null) {
			where.append(" AND UPPER(t1.DIRECCION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaapertura.getDireccion().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaapertura.getDireccion().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DIRECCION IS NOT NULL");
		}
		if (vfichaapertura != null
				&& vfichaapertura.getMunicipioempresa() != null) {
			where.append(" AND UPPER(t1.MUNICIPIOEMPRESA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaapertura.getMunicipioempresa().toUpperCase()
						+ "%");
			} else {
				params.add(
						"%" + vfichaapertura.getMunicipioempresa().toUpperCase()
								+ "%");
			}
			where.append(" AND t1.MUNICIPIOEMPRESA IS NOT NULL");
		}
		if (vfichaapertura != null
				&& vfichaapertura.getTerritorioempresa() != null) {
			where.append(
					" AND UPPER(t1.TERRITORIOEMPRESA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaapertura.getTerritorioempresa().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ vfichaapertura.getTerritorioempresa().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TERRITORIOEMPRESA IS NOT NULL");
		}
		if (vfichaapertura != null && vfichaapertura.getCp() != null) {
			where.append(" AND UPPER(t1.CP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaapertura.getCp().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaapertura.getCp().toUpperCase() + "%");
			}
			where.append(" AND t1.CP IS NOT NULL");
		}
		if (vfichaapertura != null
				&& vfichaapertura.getTelefonoempresa() != null) {
			where.append(" AND UPPER(t1.TELEFONOEMPRESA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaapertura.getTelefonoempresa().toUpperCase()
						+ "%");
			} else {
				params.add(
						"%" + vfichaapertura.getTelefonoempresa().toUpperCase()
								+ "%");
			}
			where.append(" AND t1.TELEFONOEMPRESA IS NOT NULL");
		}
		if (vfichaapertura != null
				&& vfichaapertura.getActividadeconomica() != null) {
			where.append(
					" AND UPPER(t1.ACTIVIDADECONOMICA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaapertura.getActividadeconomica().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ vfichaapertura.getActividadeconomica().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ACTIVIDADECONOMICA IS NOT NULL");
		}
		if (vfichaapertura != null
				&& vfichaapertura.getEntidadgestoracolaboradora() != null) {
			where.append(
					" AND UPPER(t1.ENTIDADGESTORACOLABORADORA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaapertura.getEntidadgestoracolaboradora()
						.toUpperCase() + "%");
			} else {
				params.add("%" + vfichaapertura.getEntidadgestoracolaboradora()
						.toUpperCase() + "%");
			}
			where.append(" AND t1.ENTIDADGESTORACOLABORADORA IS NOT NULL");
		}
		if (vfichaapertura != null && vfichaapertura.getNuevocentro() != null) {
			where.append(" AND UPPER(t1.NUEVOCENTRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaapertura.getNuevocentro().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaapertura.getNuevocentro().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NUEVOCENTRO IS NOT NULL");
		}
		if (vfichaapertura != null
				&& vfichaapertura.getReanudacionactividad() != null) {
			where.append(
					" AND UPPER(t1.REANUDACIONACTIVIDAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(
						vfichaapertura.getReanudacionactividad().toUpperCase()
								+ "%");
			} else {
				params.add("%"
						+ vfichaapertura.getReanudacionactividad().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.REANUDACIONACTIVIDAD IS NOT NULL");
		}
		if (vfichaapertura != null
				&& vfichaapertura.getCambioactividad() != null) {
			where.append(" AND UPPER(t1.CAMBIOACTIVIDAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaapertura.getCambioactividad().toUpperCase()
						+ "%");
			} else {
				params.add(
						"%" + vfichaapertura.getCambioactividad().toUpperCase()
								+ "%");
			}
			where.append(" AND t1.CAMBIOACTIVIDAD IS NOT NULL");
		}
		if (vfichaapertura != null && vfichaapertura.getTraslado() != null) {
			where.append(" AND UPPER(t1.TRASLADO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaapertura.getTraslado().toUpperCase() + "%");
			} else {
				params.add(
						"%" + vfichaapertura.getTraslado().toUpperCase() + "%");
			}
			where.append(" AND t1.TRASLADO IS NOT NULL");
		}
		if (vfichaapertura != null
				&& vfichaapertura.getNombrecentro() != null) {
			where.append(" AND UPPER(t1.NOMBRECENTRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(
						vfichaapertura.getNombrecentro().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaapertura.getNombrecentro().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NOMBRECENTRO IS NOT NULL");
		}
		if (vfichaapertura != null
				&& vfichaapertura.getMunicipiocentro() != null) {
			where.append(" AND UPPER(t1.MUNICIPIOCENTRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaapertura.getMunicipiocentro().toUpperCase()
						+ "%");
			} else {
				params.add(
						"%" + vfichaapertura.getMunicipiocentro().toUpperCase()
								+ "%");
			}
			where.append(" AND t1.MUNICIPIOCENTRO IS NOT NULL");
		}
		if (vfichaapertura != null
				&& vfichaapertura.getProvinciacentro() != null) {
			where.append(" AND UPPER(t1.PROVINCIACENTRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaapertura.getProvinciacentro().toUpperCase()
						+ "%");
			} else {
				params.add(
						"%" + vfichaapertura.getProvinciacentro().toUpperCase()
								+ "%");
			}
			where.append(" AND t1.PROVINCIACENTRO IS NOT NULL");
		}
		if (vfichaapertura != null
				&& vfichaapertura.getDireccioncentro() != null) {
			where.append(" AND UPPER(t1.DIRECCIONCENTRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaapertura.getDireccioncentro().toUpperCase()
						+ "%");
			} else {
				params.add(
						"%" + vfichaapertura.getDireccioncentro().toUpperCase()
								+ "%");
			}
			where.append(" AND t1.DIRECCIONCENTRO IS NOT NULL");
		}
		if (vfichaapertura != null
				&& vfichaapertura.getActividadeconomicacentro() != null) {
			where.append(
					" AND UPPER(t1.ACTIVIDADECONOMICACENTRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaapertura.getActividadeconomicacentro()
						.toUpperCase() + "%");
			} else {
				params.add("%" + vfichaapertura.getActividadeconomicacentro()
						.toUpperCase() + "%");
			}
			where.append(" AND t1.ACTIVIDADECONOMICACENTRO IS NOT NULL");
		}
		if (vfichaapertura != null && vfichaapertura.getFaxcentro() != null) {
			where.append(" AND UPPER(t1.FAXCENTRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaapertura.getFaxcentro().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaapertura.getFaxcentro().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.FAXCENTRO IS NOT NULL");
		}
		if (vfichaapertura != null
				&& vfichaapertura.getTelefonocentro() != null) {
			where.append(" AND UPPER(t1.TELEFONOCENTRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(
						vfichaapertura.getTelefonocentro().toUpperCase() + "%");
			} else {
				params.add(
						"%" + vfichaapertura.getTelefonocentro().toUpperCase()
								+ "%");
			}
			where.append(" AND t1.TELEFONOCENTRO IS NOT NULL");
		}
		if (vfichaapertura != null && vfichaapertura.getCpcentro() != null) {
			where.append(" AND UPPER(t1.CPCENTRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaapertura.getCpcentro().toUpperCase() + "%");
			} else {
				params.add(
						"%" + vfichaapertura.getCpcentro().toUpperCase() + "%");
			}
			where.append(" AND t1.CPCENTRO IS NOT NULL");
		}
		if (vfichaapertura != null
				&& vfichaapertura.getDiainicioactividad() != null) {
			where.append(
					" AND UPPER(t1.DIAINICIOACTIVIDAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaapertura.getDiainicioactividad().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ vfichaapertura.getDiainicioactividad().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DIAINICIOACTIVIDAD IS NOT NULL");
		}
		if (vfichaapertura != null
				&& vfichaapertura.getMesinicioactividad() != null) {
			where.append(
					" AND UPPER(t1.MESINICIOACTIVIDAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaapertura.getMesinicioactividad().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ vfichaapertura.getMesinicioactividad().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.MESINICIOACTIVIDAD IS NOT NULL");
		}
		if (vfichaapertura != null
				&& vfichaapertura.getAnioinicioactividad() != null) {
			where.append(
					" AND UPPER(t1.ANIOINICIOACTIVIDAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaapertura.getAnioinicioactividad().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ vfichaapertura.getAnioinicioactividad().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ANIOINICIOACTIVIDAD IS NOT NULL");
		}
		if (vfichaapertura != null
				&& vfichaapertura.getNssprovcentro() != null) {
			where.append(" AND UPPER(t1.NSSPROVCENTRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(
						vfichaapertura.getNssprovcentro().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaapertura.getNssprovcentro().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NSSPROVCENTRO IS NOT NULL");
		}
		if (vfichaapertura != null
				&& vfichaapertura.getNssnumcentro() != null) {
			where.append(" AND UPPER(t1.NSSNUMCENTRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(
						vfichaapertura.getNssnumcentro().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaapertura.getNssnumcentro().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NSSNUMCENTRO IS NOT NULL");
		}
		if (vfichaapertura != null
				&& vfichaapertura.getNssdigcentro() != null) {
			where.append(" AND UPPER(t1.NSSDIGCENTRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(
						vfichaapertura.getNssdigcentro().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaapertura.getNssdigcentro().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NSSDIGCENTRO IS NOT NULL");
		}
		if (vfichaapertura != null
				&& vfichaapertura.getTrabajadoreshombre() != null) {
			where.append(" AND t1.TRABAJADORESHOMBRE = ?");
			params.add(vfichaapertura.getTrabajadoreshombre());
		}
		if (vfichaapertura != null
				&& vfichaapertura.getTrabajadoresmujer() != null) {
			where.append(" AND t1.TRABAJADORESMUJER = ?");
			params.add(vfichaapertura.getTrabajadoresmujer());
		}
		if (vfichaapertura != null
				&& vfichaapertura.getTotaltrabajadores() != null) {
			where.append(" AND t1.TOTALTRABAJADORES = ?");
			params.add(vfichaapertura.getTotaltrabajadores());
		}
		if (vfichaapertura != null && vfichaapertura.getClasecentro() != null) {
			where.append(" AND UPPER(t1.CLASECENTRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaapertura.getClasecentro().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaapertura.getClasecentro().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.CLASECENTRO IS NOT NULL");
		}
		if (vfichaapertura != null
				&& vfichaapertura.getClasecentroeus() != null) {
			where.append(" AND UPPER(t1.CLASECENTROEUS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(
						vfichaapertura.getClasecentroeus().toUpperCase() + "%");
			} else {
				params.add(
						"%" + vfichaapertura.getClasecentroeus().toUpperCase()
								+ "%");
			}
			where.append(" AND t1.CLASECENTROEUS IS NOT NULL");
		}
		if (vfichaapertura != null
				&& vfichaapertura.getDescripcionobracentro() != null) {
			where.append(
					" AND UPPER(t1.DESCRIPCIONOBRACENTRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(
						vfichaapertura.getDescripcionobracentro().toUpperCase()
								+ "%");
			} else {
				params.add("%" + vfichaapertura.getDescripcionobracentro()
						.toUpperCase() + "%");
			}
			where.append(" AND t1.DESCRIPCIONOBRACENTRO IS NOT NULL");
		}
		if (vfichaapertura != null
				&& vfichaapertura.getAcompanaplanseguridad() != null) {
			where.append(
					" AND UPPER(t1.ACOMPANAPLANSEGURIDAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(
						vfichaapertura.getAcompanaplanseguridad().toUpperCase()
								+ "%");
			} else {
				params.add("%" + vfichaapertura.getAcompanaplanseguridad()
						.toUpperCase() + "%");
			}
			where.append(" AND t1.ACOMPANAPLANSEGURIDAD IS NOT NULL");
		}
		if (vfichaapertura != null
				&& vfichaapertura.getNoacompanaplanseguridad() != null) {
			where.append(
					" AND UPPER(t1.NOACOMPANAPLANSEGURIDAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaapertura.getNoacompanaplanseguridad()
						.toUpperCase() + "%");
			} else {
				params.add("%" + vfichaapertura.getNoacompanaplanseguridad()
						.toUpperCase() + "%");
			}
			where.append(" AND t1.NOACOMPANAPLANSEGURIDAD IS NOT NULL");
		}
		if (vfichaapertura != null
				&& vfichaapertura.getAdjuntaproyectotecnico() != null) {
			where.append(
					" AND UPPER(t1.ADJUNTAPROYECTOTECNICO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(
						vfichaapertura.getAdjuntaproyectotecnico().toUpperCase()
								+ "%");
			} else {
				params.add("%" + vfichaapertura.getAdjuntaproyectotecnico()
						.toUpperCase() + "%");
			}
			where.append(" AND t1.ADJUNTAPROYECTOTECNICO IS NOT NULL");
		}
		if (vfichaapertura != null
				&& vfichaapertura.getNoadjuntaproyectotecnico() != null) {
			where.append(
					" AND UPPER(t1.NOADJUNTAPROYECTOTECNICO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaapertura.getNoadjuntaproyectotecnico()
						.toUpperCase() + "%");
			} else {
				params.add("%" + vfichaapertura.getNoadjuntaproyectotecnico()
						.toUpperCase() + "%");
			}
			where.append(" AND t1.NOADJUNTAPROYECTOTECNICO IS NOT NULL");
		}
		if (vfichaapertura != null
				&& vfichaapertura.getMaquinariaherramientas() != null) {
			where.append(
					" AND UPPER(t1.MAQUINARIAHERRAMIENTAS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(
						vfichaapertura.getMaquinariaherramientas().toUpperCase()
								+ "%");
			} else {
				params.add("%" + vfichaapertura.getMaquinariaherramientas()
						.toUpperCase() + "%");
			}
			where.append(" AND t1.MAQUINARIAHERRAMIENTAS IS NOT NULL");
		}
		if (vfichaapertura != null
				&& vfichaapertura.getSuperficieconstruida() != null) {
			where.append(" AND t1.SUPERFICIECONSTRUIDA = ?");
			params.add(vfichaapertura.getSuperficieconstruida());
		}
		if (vfichaapertura != null
				&& vfichaapertura.getPotenciainstalada() != null) {
			where.append(" AND t1.POTENCIAINSTALADA = ?");
			params.add(vfichaapertura.getPotenciainstalada());
		}
		if (vfichaapertura != null
				&& vfichaapertura.getTrabajoanexoi() != null) {
			where.append(" AND UPPER(t1.TRABAJOANEXOI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(
						vfichaapertura.getTrabajoanexoi().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaapertura.getTrabajoanexoi().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TRABAJOANEXOI IS NOT NULL");
		}
		if (vfichaapertura != null
				&& vfichaapertura.getNotrabajoanexoi() != null) {
			where.append(" AND UPPER(t1.NOTRABAJOANEXOI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaapertura.getNotrabajoanexoi().toUpperCase()
						+ "%");
			} else {
				params.add(
						"%" + vfichaapertura.getNotrabajoanexoi().toUpperCase()
								+ "%");
			}
			where.append(" AND t1.NOTRABAJOANEXOI IS NOT NULL");
		}
		if (vfichaapertura != null
				&& vfichaapertura.getApartadoanexoi() != null) {
			where.append(" AND UPPER(t1.APARTADOANEXOI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(
						vfichaapertura.getApartadoanexoi().toUpperCase() + "%");
			} else {
				params.add(
						"%" + vfichaapertura.getApartadoanexoi().toUpperCase()
								+ "%");
			}
			where.append(" AND t1.APARTADOANEXOI IS NOT NULL");
		}
		if (vfichaapertura != null
				&& vfichaapertura.getApartadoanexoieus() != null) {
			where.append(
					" AND UPPER(t1.APARTADOANEXOIEUS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaapertura.getApartadoanexoieus().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ vfichaapertura.getApartadoanexoieus().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.APARTADOANEXOIEUS IS NOT NULL");
		}
		if (vfichaapertura != null && vfichaapertura.getFirma() != null) {
			where.append(" AND UPPER(t1.FIRMA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaapertura.getFirma().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaapertura.getFirma().toUpperCase() + "%");
			}
			where.append(" AND t1.FIRMA IS NOT NULL");
		}
		if (vfichaapertura != null && vfichaapertura.getCodobra() != null) {
			where.append(" AND t1.CODOBRA = ?");
			params.add(vfichaapertura.getCodobra());
		}
		if (vfichaapertura != null && vfichaapertura.getTipoobra() != null) {
			where.append(" AND UPPER(t1.TIPOOBRA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaapertura.getTipoobra().toUpperCase() + "%");
			} else {
				params.add(
						"%" + vfichaapertura.getTipoobra().toUpperCase() + "%");
			}
			where.append(" AND t1.TIPOOBRA IS NOT NULL");
		}
		if (vfichaapertura != null && vfichaapertura.getTipoobraeus() != null) {
			where.append(" AND UPPER(t1.TIPOOBRAEUS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaapertura.getTipoobraeus().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaapertura.getTipoobraeus().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TIPOOBRAEUS IS NOT NULL");
		}
		if (vfichaapertura != null
				&& vfichaapertura.getDirexactaobra() != null) {
			where.append(" AND UPPER(t1.DIREXACTAOBRA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(
						vfichaapertura.getDirexactaobra().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaapertura.getDirexactaobra().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DIREXACTAOBRA IS NOT NULL");
		}
		if (vfichaapertura != null
				&& vfichaapertura.getFechacomienzoobra() != null) {
			where.append(" AND t1.FECHACOMIENZOOBRA = ?");
			params.add(vfichaapertura.getFechacomienzoobra());
		}
		if (vfichaapertura != null
				&& vfichaapertura.getDuracionprevista() != null) {
			where.append(" AND UPPER(t1.DURACIONPREVISTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaapertura.getDuracionprevista().toUpperCase()
						+ "%");
			} else {
				params.add(
						"%" + vfichaapertura.getDuracionprevista().toUpperCase()
								+ "%");
			}
			where.append(" AND t1.DURACIONPREVISTA IS NOT NULL");
		}
		if (vfichaapertura != null
				&& vfichaapertura.getDuracionprevistacontratista() != null) {
			where.append(
					" AND UPPER(t1.DURACIONPREVISTACONTRATISTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaapertura.getDuracionprevistacontratista()
						.toUpperCase() + "%");
			} else {
				params.add("%" + vfichaapertura.getDuracionprevistacontratista()
						.toUpperCase() + "%");
			}
			where.append(" AND t1.DURACIONPREVISTACONTRATISTA IS NOT NULL");
		}
		if (vfichaapertura != null
				&& vfichaapertura.getNumerocontratista() != null) {
			where.append(" AND t1.NUMEROCONTRATISTA = ?");
			params.add(vfichaapertura.getNumerocontratista());
		}
		if (vfichaapertura != null
				&& vfichaapertura.getRealizatrabajos() != null) {
			where.append(" AND UPPER(t1.REALIZATRABAJOS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaapertura.getRealizatrabajos().toUpperCase()
						+ "%");
			} else {
				params.add(
						"%" + vfichaapertura.getRealizatrabajos().toUpperCase()
								+ "%");
			}
			where.append(" AND t1.REALIZATRABAJOS IS NOT NULL");
		}
		if (vfichaapertura != null
				&& vfichaapertura.getNorealizatrabajos() != null) {
			where.append(
					" AND UPPER(t1.NOREALIZATRABAJOS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaapertura.getNorealizatrabajos().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ vfichaapertura.getNorealizatrabajos().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NOREALIZATRABAJOS IS NOT NULL");
		}
		if (vfichaapertura != null && vfichaapertura.getTipoanexo2() != null) {
			where.append(" AND UPPER(t1.TIPOANEXO2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaapertura.getTipoanexo2().toUpperCase() + "%");
			} else {
				params.add("%" + vfichaapertura.getTipoanexo2().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TIPOANEXO2 IS NOT NULL");
		}
		if (vfichaapertura != null
				&& vfichaapertura.getDescripcionanexo2() != null) {
			where.append(
					" AND UPPER(t1.DESCRIPCIONANEXO2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vfichaapertura.getDescripcionanexo2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ vfichaapertura.getDescripcionanexo2().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DESCRIPCIONANEXO2 IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
